/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.ds.r_tree_based;

import cz.krystofcejchan.base_ds.AbstractRTree2D;
import cz.krystofcejchan.ds.r_tree_based.MVREntry;
import cz.krystofcejchan.ds.r_tree_based.MVRLeafRef;
import cz.krystofcejchan.model.BoundingBox2D;
import cz.krystofcejchan.model.Node2D;
import cz.krystofcejchan.model.R2Entry;
import cz.krystofcejchan.model.TimeInterval;
import cz.krystofcejchan.model.interfaces.SpatioTemporalObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;

final class MVRTree<T>
extends AbstractRTree2D<MVREntry> {
    private final Map<UUID, SpatioTemporalObject<T>> store = new HashMap<UUID, SpatioTemporalObject<T>>();
    private final Map<Object, UUID> keyToId = new HashMap<Object, UUID>();

    MVRTree(int maxEntries) {
        super(maxEntries);
    }

    @Override
    protected MVREntry makeInternal(BoundingBox2D mbr, Node2D<MVREntry> child) {
        return MVREntry.internal(mbr, child);
    }

    List<MVRLeafRef> insert(SpatioTemporalObject<T> obj) {
        UUID id = UUID.randomUUID();
        this.store.put(id, obj);
        this.keyToId.put(obj.key(), id);
        MVREntry leaf = MVREntry.leaf(obj.box(), obj.time(), id);
        this.insertEntry(leaf);
        return List.of(new MVRLeafRef(leaf.getMbr(), leaf.interval, id));
    }

    List<MVRLeafRef> logicalDelete(Object key, Instant deletionTime) {
        UUID id = this.keyToId.get(key);
        if (id == null) {
            return Collections.emptyList();
        }
        SpatioTemporalObject<T> obj = this.store.get(id);
        if (obj == null) {
            return Collections.emptyList();
        }
        ArrayList<MVRLeafRef> affected = new ArrayList<MVRLeafRef>();
        this.findAndUpdate(this.root, id, e -> {
            if (e.interval.end().equals(TimeInterval.END_OF_TIME)) {
                e.interval = e.interval.withEnd(deletionTime);
                affected.add(new MVRLeafRef(e.getMbr(), e.interval, e.leafId));
            }
            return true;
        });
        return affected;
    }

    List<SpatioTemporalObject<T>> query(BoundingBox2D area, TimeInterval time) {
        ArrayList<SpatioTemporalObject<T>> out = new ArrayList<SpatioTemporalObject<T>>();
        if (time == null) {
            time = TimeInterval.instant(Instant.now());
        }
        this.queryRec(this.root, area, time, out);
        return out;
    }

    SpatioTemporalObject<T> getById(UUID id) {
        return this.store.get(id);
    }

    private void queryRec(Node2D<MVREntry> n, BoundingBox2D area, TimeInterval ti, List<SpatioTemporalObject<T>> out) {
        if (n.isLeaf()) {
            for (MVREntry e : n.getEntries()) {
                SpatioTemporalObject<T> o;
                if (!e.getMbr().intersects(area) || !e.interval.overlaps(ti) || (o = this.store.get(e.leafId)) == null) continue;
                out.add(o);
            }
        } else {
            for (MVREntry e : n.getEntries()) {
                if (!e.getMbr().intersects(area)) continue;
                this.queryRec(this.cast(e.getChild()), area, ti, out);
            }
        }
    }

    private Node2D<MVREntry> cast(Node2D<? extends R2Entry> n) {
        return n;
    }

    private boolean findAndUpdate(Node2D<MVREntry> n, UUID id, Predicate<MVREntry> updater) {
        if (n.isLeaf()) {
            for (MVREntry e : n.getEntries()) {
                if (!Objects.equals(e.leafId, id)) continue;
                return updater.test(e);
            }
        } else {
            for (MVREntry e : n.getEntries()) {
                if (!this.findAndUpdate(this.cast(e.getChild()), id, updater)) continue;
                return true;
            }
        }
        return false;
    }
}

