/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.ds.r_tree_based;

import cz.krystofcejchan.ds.r_tree_based.R3Entry;
import cz.krystofcejchan.model.BoundingBox3D;
import cz.krystofcejchan.utils.classes.Pair;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class RTree3D<T> {
    private final int M;
    private Node3D<T> root = new Node3D(true);
    private final Map<UUID, R3Entry<T>> idToEntry = new HashMap<UUID, R3Entry<T>>();

    RTree3D(int maxEntries) {
        this.M = Math.max(4, maxEntries);
    }

    void insert(R3Entry<T> e) {
        Node3D<T> leaf = this.chooseLeaf(this.root, e);
        leaf.entries.add(e);
        e.owner = leaf;
        this.idToEntry.put(e.payloadId, e);
        this.adjustUp(leaf);
        if (leaf.entries.size() > this.M) {
            this.split(leaf);
        }
    }

    Collection<UUID> search(BoundingBox3D box) {
        ArrayList<UUID> out = new ArrayList<UUID>();
        this.searchRec(this.root, box, out);
        return out;
    }

    void updateEndTime(UUID payloadId, Instant newEnd) {
        R3Entry<T> e = this.idToEntry.get(payloadId);
        if (e == null) {
            return;
        }
        e.mbr = new BoundingBox3D(e.mbr.minX(), e.mbr.minY(), e.mbr.maxX(), e.mbr.maxY(), e.mbr.minT(), newEnd.getEpochSecond());
        this.adjustUp(e.owner);
    }

    private void searchRec(Node3D<T> n, BoundingBox3D b, List<UUID> out) {
        if (n.isLeaf) {
            for (R3Entry e : n.entries) {
                if (!e.mbr.intersects(b)) continue;
                out.add(e.payloadId);
            }
        } else {
            for (R3Entry e : n.entries) {
                if (!e.mbr.intersects(b)) continue;
                this.searchRec(e.child, b, out);
            }
        }
    }

    private Node3D<T> chooseLeaf(Node3D<T> n, R3Entry<T> e) {
        if (n.isLeaf) {
            return n;
        }
        Node3D best = null;
        double bestInc = Double.POSITIVE_INFINITY;
        for (R3Entry ce : n.entries) {
            double old = ce.mbr.volume();
            double inc = BoundingBox3D.union(ce.mbr, e.mbr).volume() - old;
            if (inc < bestInc) {
                bestInc = inc;
                best = ce.child;
                continue;
            }
            if (inc != bestInc) continue;
            assert (best != null);
            if (!(ce.child.mbrVolume() < best.mbrVolume())) continue;
            best = ce.child;
        }
        assert (best != null);
        return this.chooseLeaf(best, e);
    }

    private void adjustUp(Node3D<T> n) {
        while (n != null) {
            n.recalcMBR();
            n = n.parent;
        }
    }

    private void split(Node3D<T> n) {
        Pair seeds = this.pickSeeds(n.entries);
        Node3D n1 = new Node3D(n.isLeaf);
        Node3D n2 = new Node3D(n.isLeaf);
        n1.parent = n.parent;
        n2.parent = n.parent;
        n1.entries.add(seeds.a());
        seeds.a().owner = n1;
        n2.entries.add(seeds.b());
        seeds.b().owner = n2;
        ArrayList rem = new ArrayList(n.entries);
        rem.remove(seeds.a());
        rem.remove(seeds.b());
        while (!rem.isEmpty()) {
            double inc2;
            R3Entry e2 = (R3Entry)rem.removeLast();
            double inc1 = this.volInc(n1, e2);
            if (inc1 < (inc2 = this.volInc(n2, e2))) {
                n1.entries.add(e2);
                e2.owner = n1;
                continue;
            }
            if (inc2 < inc1) {
                n2.entries.add(e2);
                e2.owner = n2;
                continue;
            }
            if (n1.mbrVolume() < n2.mbrVolume()) {
                n1.entries.add(e2);
                e2.owner = n1;
                continue;
            }
            n2.entries.add(e2);
            e2.owner = n2;
        }
        n1.recalcMBR();
        n2.recalcMBR();
        if (n.parent == null) {
            Node3D r = new Node3D(false);
            r.entries.add(R3Entry.internal(n1.mbr(), n1));
            r.entries.add(R3Entry.internal(n2.mbr(), n2));
            n1.parent = r;
            n2.parent = r;
            this.root = r;
        } else {
            Node3D p = n.parent;
            p.entries.removeIf(e -> e.child == n);
            p.entries.add(R3Entry.internal(n1.mbr(), n1));
            p.entries.add(R3Entry.internal(n2.mbr(), n2));
            while (p != null) {
                if (p.entries.size() > this.M) {
                    this.split(p);
                }
                p.recalcMBR();
                p = p.parent;
            }
        }
    }

    private double volInc(Node3D<T> n, R3Entry<T> e) {
        return BoundingBox3D.union(n.mbr(), e.mbr).volume() - n.mbrVolume();
    }

    private Pair<R3Entry<T>, R3Entry<T>> pickSeeds(List<R3Entry<T>> es) {
        double worst = -1.0;
        R3Entry<T> s1 = null;
        R3Entry<T> s2 = null;
        for (int i = 0; i < es.size(); ++i) {
            for (int j = i + 1; j < es.size(); ++j) {
                R3Entry<T> a = es.get(i);
                R3Entry<T> b = es.get(j);
                double d = BoundingBox3D.union(a.mbr, b.mbr).volume() - a.mbr.volume() - b.mbr.volume();
                if (!(d > worst)) continue;
                worst = d;
                s1 = a;
                s2 = b;
            }
        }
        return new Pair<Object, Object>(s1, s2);
    }

    static final class Node3D<T> {
        final boolean isLeaf;
        final List<R3Entry<T>> entries = new ArrayList<R3Entry<T>>();
        Node3D<T> parent;
        BoundingBox3D cached;

        Node3D(boolean leaf) {
            this.isLeaf = leaf;
        }

        void recalcMBR() {
            BoundingBox3D b = null;
            for (R3Entry<T> e : this.entries) {
                b = b == null ? e.mbr : BoundingBox3D.union(b, e.mbr);
            }
            this.cached = b;
        }

        BoundingBox3D mbr() {
            if (this.cached == null) {
                this.recalcMBR();
            }
            return this.cached;
        }

        double mbrVolume() {
            BoundingBox3D b = this.mbr();
            return b == null ? 0.0 : b.volume();
        }
    }
}

