/*
 * Decompiled with CFR 0.152.
 */
package cz.krystofcejchan.model;

import cz.krystofcejchan.model.BoundingBox2D;
import cz.krystofcejchan.model.TimeInterval;

public record BoundingBox3D(double minX, double minY, double maxX, double maxY, long minT, long maxT) {
    public static final BoundingBox3D FULL_2D = new BoundingBox3D(-4.9E-324, -4.9E-324, Double.MAX_VALUE, Double.MAX_VALUE, -2305843009213693952L, 0x1FFFFFFFFFFFFFFFL);

    public BoundingBox3D {
        assert (!(minX > maxX) && !(minY > maxY) && minT <= maxT);
    }

    public static BoundingBox3D from2DAndTime(BoundingBox2D b2, TimeInterval ti) {
        return new BoundingBox3D(b2.minX(), b2.minY(), b2.maxX(), b2.maxY(), ti.start().getEpochSecond(), ti.end().getEpochSecond());
    }

    public BoundingBox3D withTime(TimeInterval ti) {
        return new BoundingBox3D(this.minX, this.minY, this.maxX, this.maxY, ti.start().getEpochSecond(), ti.end().getEpochSecond());
    }

    public boolean intersects(BoundingBox3D o) {
        boolean s2 = !(o.minX > this.maxX || o.maxX < this.minX || o.minY > this.maxY || o.maxY < this.minY);
        boolean st = o.minT <= this.maxT && o.maxT >= this.minT;
        return s2 && st;
    }

    public static BoundingBox3D union(BoundingBox3D a, BoundingBox3D b) {
        return new BoundingBox3D(Math.min(a.minX, b.minX), Math.min(a.minY, b.minY), Math.max(a.maxX, b.maxX), Math.max(a.maxY, b.maxY), Math.min(a.minT, b.minT), Math.max(a.maxT, b.maxT));
    }

    public double volume() {
        return (this.maxX - this.minX) * (this.maxY - this.minY) * (double)Math.max(1L, this.maxT - this.minT);
    }
}

