/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.base;

import cz.martlin.xspf.playlist.base.XSPFCollection;
import cz.martlin.xspf.playlist.base.XSPFNode;
import cz.martlin.xspf.util.XMLDocumentUtilityHelper;
import cz.martlin.xspf.util.XSPFException;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XSPFElement
extends XSPFNode {
    private final Element element;

    public XSPFElement(Element element) {
        Objects.requireNonNull(element, "The element has to be specified");
        this.element = element;
    }

    protected Element getElement() {
        return this.element;
    }

    private Element getElementClone() {
        Element container = this.getElement();
        return UTIL.getElemClone(container);
    }

    @Override
    public Node getNode() {
        return this.getElement();
    }

    private static String uriToStr(URI uri) {
        return uri.toASCIIString();
    }

    private static URI strToUri(String text) {
        return URI.create(text);
    }

    private Duration milisStrToDuration(String text) {
        long milis = Long.parseLong(text);
        return Duration.ofMillis(milis);
    }

    private static String durationToMilisStr(Duration duration) {
        long milis = duration.toMillis();
        return Long.toString(milis);
    }

    private LocalDateTime textToDate(String text) {
        TemporalAccessor ta = DateTimeFormatter.ISO_DATE_TIME.parse(text);
        return LocalDateTime.from(ta);
    }

    private static String dateToText(LocalDateTime date) {
        LocalDateTime ta = date;
        return DateTimeFormatter.ISO_DATE_TIME.format(ta);
    }

    private static String intToStr(int num) {
        return Integer.toString(num);
    }

    private static int strToInt(String text) {
        return Integer.parseInt(text);
    }

    protected String getStr() throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getElementValueOrNull(elem, XMLDocumentUtilityHelper.TextToValueMapper.TEXT_TO_STRING);
    }

    protected String getStr(String name) throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getChildElementValueOrNull(elem, name, XMLDocumentUtilityHelper.TextToValueMapper.TEXT_TO_STRING);
    }

    protected void setStr(String value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setElementValue(elem, value, XMLDocumentUtilityHelper.ValueToTextMapper.STRING_TO_TEXT);
    }

    protected void setStr(String name, String value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setChildElementValue(elem, name, value, XMLDocumentUtilityHelper.ValueToTextMapper.STRING_TO_TEXT);
    }

    protected URI getUri(String name) throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getChildElementValueOrNull(elem, name, t -> XSPFElement.strToUri(t));
    }

    protected void setUri(String name, URI value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setChildElementValue(elem, name, value, v -> XSPFElement.uriToStr(v));
    }

    protected URI getUriAttr(String name) throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getElementAttrOrNull(elem, name, t -> XSPFElement.strToUri(t));
    }

    protected void setUriAttr(String name, URI value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setElementAttr(elem, name, value, v -> XSPFElement.uriToStr(v));
    }

    protected LocalDateTime getDate(String name) throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getChildElementValueOrNull(elem, name, t -> this.textToDate(t));
    }

    protected void setDate(String name, LocalDateTime value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setChildElementValue(elem, name, value, v -> XSPFElement.dateToText(v));
    }

    protected Duration getDuration(String name) throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getChildElementValueOrNull(elem, name, t -> this.milisStrToDuration(t));
    }

    protected void setDuration(String name, Duration value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setChildElementValue(elem, name, value, v -> XSPFElement.durationToMilisStr(v));
    }

    protected Integer getInt(String name) throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getChildElementValueOrNull(elem, name, t -> XSPFElement.strToInt(t));
    }

    protected void setInt(String name, int value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setChildElementValue(elem, name, value, v -> XSPFElement.intToStr(v));
    }

    protected URI getUri() throws XSPFException {
        Element elem = this.getElement();
        return UTIL.getElementValueOrNull(elem, t -> XSPFElement.strToUri(t));
    }

    protected void setUri(URI value) throws XSPFException {
        Element elem = this.getElement();
        UTIL.setElementValue(elem, value, v -> XSPFElement.uriToStr(v));
    }

    protected <E extends XSPFElement> XSPFCollection<E> getCollection(XSPFCollectionFactory<E> factory) throws XSPFException {
        Element clone = this.getElementClone();
        return factory.create(clone);
    }

    protected <E extends XSPFElement> XSPFCollection<E> collection(XSPFCollectionFactory<E> factory) throws XSPFException {
        Element container = this.getElement();
        return factory.create(container);
    }

    protected <E extends XSPFElement, C extends XSPFCollection<E>> void setCollection(XSPFCollection<E> collection) throws XSPFException {
        Element container = this.getElement();
        String name = collection.elemName();
        Stream<Element> newElems = collection.list().map(x -> x.getElement());
        UTIL.replaceChildElementsByClone(container, name, newElems);
    }

    protected <E extends XSPFElement> XSPFCollection<E> getCollection(String name, XSPFCollectionFactory<E> factory) throws XSPFException {
        Element owner = this.getElement();
        Element coontainerClone = UTIL.getChildElemCloneOrNull(owner, name);
        if (coontainerClone == null) {
            return null;
        }
        return factory.create(coontainerClone);
    }

    protected <E extends XSPFElement> XSPFCollection<E> collection(String name, XSPFCollectionFactory<E> factory) throws XSPFException {
        Element owner = this.getElement();
        Element container = UTIL.getOrCreateChildElem(owner, name);
        return factory.create(container);
    }

    protected <E extends XSPFElement, C extends XSPFCollection<E>> void setCollection(String name, XSPFCollection<E> collection) throws XSPFException {
        Element owner = this.getElement();
        Element container = UTIL.getOrCreateChildElem(owner, name);
        String childrenName = collection.elemName();
        Stream<Element> newElems = collection.list().map(x -> x.getElement()).map(e -> UTIL.getElemClone((Element)e));
        UTIL.replaceChildElementsByClone(container, childrenName, newElems);
    }

    @FunctionalInterface
    public static interface XSPFCollectionFactory<E extends XSPFElement> {
        public XSPFCollection<E> create(Element var1);
    }
}

