/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.elements;

import cz.martlin.xspf.playlist.base.XSPFNode;
import cz.martlin.xspf.playlist.collections.XSPFExtensions;
import cz.martlin.xspf.playlist.collections.XSPFLinks;
import cz.martlin.xspf.playlist.collections.XSPFMetas;
import cz.martlin.xspf.playlist.collections.XSPFTracks;
import cz.martlin.xspf.playlist.elements.XSPFAttribution;
import cz.martlin.xspf.playlist.elements.XSPFPlaylist;
import cz.martlin.xspf.util.XMLDocumentUtilityHelper;
import cz.martlin.xspf.util.XMLFileLoaderStorer;
import cz.martlin.xspf.util.XSPFException;
import java.io.File;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSPFFile
extends XSPFNode {
    protected static final String XSPF_STANDART_VERSION = "1";
    private final Document document;

    protected XSPFFile(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public Node getNode() {
        return this.document;
    }

    public XSPFPlaylist getPlaylist() throws XSPFException {
        return this.getOne("playlist", e -> new XSPFPlaylist((Element)e));
    }

    public XSPFPlaylist playlist() throws XSPFException {
        return this.one("playlist", e -> new XSPFPlaylist((Element)e));
    }

    public void setPlaylist(XSPFPlaylist playlist) throws XSPFException {
        this.setOne("playlist", playlist);
    }

    public XSPFMetas newMetas() throws XSPFException {
        Element root = UTIL.createNewElement(this.document, "playlist");
        return new XSPFMetas(root);
    }

    public XSPFLinks newLinks() throws XSPFException {
        Element root = UTIL.createNewElement(this.document, "playlist");
        return new XSPFLinks(root);
    }

    public XSPFExtensions newExtensions() throws XSPFException {
        Element root = UTIL.createNewElement(this.document, "playlist");
        return new XSPFExtensions(root);
    }

    public XSPFTracks newTracks() throws XSPFException {
        Element trackList = UTIL.createNewElement(this.document, "trackList");
        return new XSPFTracks(trackList);
    }

    public XSPFPlaylist newPlaylist() throws XSPFException {
        Element playlist = UTIL.createNewElement(this.document, "playlist");
        return new XSPFPlaylist(playlist);
    }

    public XSPFAttribution newAttribution() throws XSPFException {
        Element attribution = UTIL.createNewElement(this.document, "attribution");
        return new XSPFAttribution(attribution);
    }

    public static XSPFFile load(File file) throws XSPFException {
        Document document = XMLFileLoaderStorer.loadDocument(file);
        XSPFFile.verify(document);
        return new XSPFFile(document);
    }

    public static XSPFFile create() throws XSPFException {
        Document document = XMLFileLoaderStorer.createEmptyDocument();
        XSPFFile.prepare(document);
        return new XSPFFile(document);
    }

    public void save(File file) throws XSPFException {
        XMLFileLoaderStorer.saveDocument(this.document, file);
    }

    private static void prepare(Document document) throws XSPFException {
        Element root = UTIL.getOrCreateChildElem(document, "playlist");
        UTIL.register(root);
        XSPFFile.specifyVersion(root);
    }

    private static void specifyVersion(Element root) throws XSPFException {
        XSPFNode.UTIL.setElementAttr(root, "version", XSPF_STANDART_VERSION, XMLDocumentUtilityHelper.ValueToTextMapper.STRING_TO_TEXT);
    }

    private static void verify(Document document) throws XSPFException {
        Element root = UTIL.getChildElemOrNull(document, "playlist");
        if (root == null) {
            throw new XSPFException("No root element.");
        }
        XSPFFile.verifyVersion(root);
    }

    private static void verifyVersion(Element root) throws XSPFException {
        String version = XSPFNode.UTIL.getElementAttrOrNull(root, "version", XMLDocumentUtilityHelper.TextToValueMapper.TEXT_TO_STRING);
        if (!version.equals(XSPF_STANDART_VERSION)) {
            throw new XSPFException("The supported version of XSPF is 1");
        }
    }

    public int hashCode() {
        try {
            return Objects.hash(this.playlist());
        }
        catch (XSPFException e) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSPFFile other = (XSPFFile)obj;
        try {
            return Objects.equals(this.playlist(), other.playlist());
        }
        catch (XSPFException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("XSPFFile [");
        try {
            builder.append(this.getPlaylist());
        }
        catch (XSPFException e) {
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }
}

