/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.elements;

import cz.martlin.xspf.playlist.base.XSPFElement;
import cz.martlin.xspf.util.XSPFException;
import java.net.URI;
import java.util.Objects;
import org.w3c.dom.Element;

public class XSPFLink
extends XSPFElement {
    public XSPFLink(Element link) {
        super(link);
    }

    public URI getRel() throws XSPFException {
        return this.getUriAttr("rel");
    }

    public void setRel(URI rel) throws XSPFException {
        this.setUriAttr("rel", rel);
    }

    public URI getContent() throws XSPFException {
        return this.getUri();
    }

    public void setContent(URI rel) throws XSPFException {
        this.setUri(rel);
    }

    public int hashCode() {
        try {
            return Objects.hash(this.getContent(), this.getRel());
        }
        catch (XSPFException e) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSPFLink other = (XSPFLink)obj;
        try {
            return Objects.equals(this.getContent(), other.getContent()) && Objects.equals(this.getRel(), other.getRel());
        }
        catch (XSPFException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("XSPFLink [");
        try {
            builder.append("rel=");
            builder.append(this.getRel());
            builder.append(", content=");
            builder.append(this.getContent());
        }
        catch (XSPFException e) {
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }
}

