/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.util;

import cz.martlin.xspf.util.XSPFException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentUtilityHelper {
    private final String nsName;
    private final String nsURL;

    public XMLDocumentUtilityHelper(String nsName, String nsURL) {
        this.nsName = nsName;
        this.nsURL = nsURL;
    }

    public void specifyNSattribute(Element elem) throws XSPFException {
        String attrName = this.namespaceAttrName();
        String atrrValue = this.nsURL;
        elem.setAttribute(attrName, atrrValue);
    }

    private String namespaceAttrName() {
        Object attrName = this.nsName != null ? "xmlns:" + this.nsName : "xmlns";
        return attrName;
    }

    public Element createNew(Node context, String elemName) throws XSPFException {
        try {
            Document document = this.documentOfNode(context);
            return this.createNewElement(document, elemName);
        }
        catch (Exception e) {
            throw new XSPFException("Canot create new element", e);
        }
    }

    public Element createChild(Node owner, String elemName) throws XSPFException {
        try {
            return this.createChildElement(owner, elemName);
        }
        catch (Exception e) {
            throw new XSPFException("Canot create child element", e);
        }
    }

    public Element getChildOrNull(Node owner, String elemName) throws XSPFException {
        try {
            return this.getChildElement(owner, elemName, false);
        }
        catch (Exception e) {
            throw new XSPFException("Canot get (or null) child element", e);
        }
    }

    public Element getOrCreateChild(Node owner, String elemName) throws XSPFException {
        try {
            Element child = this.getChildElement(owner, elemName, false);
            if (child == null) {
                child = this.createChildElement(owner, elemName);
            }
            return child;
        }
        catch (Exception e) {
            throw new XSPFException("Canot get or create child element", e);
        }
    }

    public Stream<Element> getChildren(Node owner, String elemName) throws XSPFException {
        try {
            return this.getChildrenElements(owner, elemName);
        }
        catch (Exception e) {
            throw new XSPFException("Canot get children elements", e);
        }
    }

    public boolean hasChildren(Node owner, String elemName) throws XSPFException {
        try {
            return this.getChildrenElements(owner, elemName).findAny().isPresent();
        }
        catch (Exception e) {
            throw new XSPFException("Canot figure out existence of children elements", e);
        }
    }

    public void addChild(Node owner, Element child) throws XSPFException {
        try {
            this.addChildElement(owner, child);
        }
        catch (Exception e) {
            throw new XSPFException("Canot add child element", e);
        }
    }

    public void removeChild(Node owner, Element child) throws XSPFException {
        try {
            this.removeChildElement(owner, child);
        }
        catch (Exception e) {
            throw new XSPFException("Canot remove child element", e);
        }
    }

    private Document documentOfNode(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    private Element createNewElement(Document document, String elemName) {
        return document.createElement(this.fullName(elemName));
    }

    private Element createChildElement(Node owner, String elemName) {
        Document document = this.documentOfNode(owner);
        Element elem = this.createNewElement(document, elemName);
        this.addChildElement(owner, elem);
        return elem;
    }

    private void addChildElement(Node owner, Element elem) {
        owner.appendChild(elem);
    }

    private void removeChildElement(Node owner, Element elem) {
        owner.removeChild(elem);
    }

    private Element getChildElement(Node owner, String elemName, boolean failOnMissing) throws XSPFException {
        Stream<Element> children = this.listChildren(owner, elemName);
        List list = children.collect(Collectors.toList());
        if (list.size() < 1) {
            if (failOnMissing) {
                throw new XSPFException("No such element " + elemName);
            }
            return null;
        }
        if (list.size() > 1) {
            throw new XSPFException("More than one " + elemName + " elements");
        }
        Node child = (Node)list.get(0);
        Element childElem = (Element)child;
        return childElem;
    }

    private Stream<Element> getChildrenElements(Node owner, String elemName) throws XSPFException {
        return this.listChildren(owner, elemName);
    }

    private Stream<Element> listChildren(Node container, String elemName) {
        NodeList children = container.getChildNodes();
        return IntStream.range(0, children.getLength()).mapToObj(i -> children.item(i)).filter(n -> n.getNodeType() == 1).map(n -> (Element)n).filter(e -> this.isElemOfName((Element)e, elemName)).collect(Collectors.toList()).stream();
    }

    private boolean isElemOfName(Element elem, String elemName) {
        if (elemName == null) {
            return true;
        }
        return elem.getTagName().equals(this.fullName(elemName));
    }

    public String getElementValue(Element elem) throws XSPFException {
        String content = elem.getTextContent();
        if (content == null) {
            throw new XSPFException("The element " + elem.getTagName() + " has no content");
        }
        return content;
    }

    public String getElementValueOrNull(Element elem) throws XSPFException {
        return elem.getTextContent();
    }

    public void setElementValue(Element elem, String value) {
        elem.setTextContent(value);
    }

    public String getAttrValue(Element elem, String attrName) throws XSPFException {
        String content = elem.getAttribute(this.fullName(attrName));
        if (content == null) {
            throw new XSPFException("The attribute " + attrName + " does not exist");
        }
        return content;
    }

    public String getAttrValueOrNull(Element elem, String attrName) throws XSPFException {
        if (elem.hasAttribute(this.fullName(attrName))) {
            return elem.getAttribute(this.fullName(attrName));
        }
        return null;
    }

    public void setAttrValue(Element elem, String attrName, String value) {
        elem.setAttribute(this.fullName(attrName), value);
    }

    public <T> T textToValue(String text, TextToValueMapper<T> mapper) throws XSPFException {
        try {
            if (text == null) {
                return null;
            }
            return mapper.textToValue(text.trim());
        }
        catch (Exception e) {
            throw new XSPFException("Cannot convert " + text + " value", e);
        }
    }

    public <T> String valueToText(T value, ValueToTextMapper<T> mapper) throws XSPFException {
        try {
            if (value == null) {
                return null;
            }
            return mapper.valueToText(value);
        }
        catch (Exception e) {
            throw new XSPFException("Cannot convert " + value + " value", e);
        }
    }

    private String fullName(String elemName) {
        if (this.nsName != null) {
            return this.nsName + ":" + elemName;
        }
        return elemName;
    }

    public Element clone(Element elem) {
        return (Element)elem.cloneNode(true);
    }

    @FunctionalInterface
    public static interface ValueToTextMapper<T> {
        public static final ValueToTextMapper<String> STRING_TO_TEXT = s -> s;

        public String valueToText(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface TextToValueMapper<T> {
        public static final TextToValueMapper<String> TEXT_TO_STRING = s -> s;

        public T textToValue(String var1) throws Exception;
    }
}

