/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.util;

import cz.martlin.xspf.util.XSPFException;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFileLoaderStorer {
    public static Document loadDocument(File file) throws XSPFException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            return document;
        }
        catch (Exception e) {
            throw new XSPFException("Cannot load file", e);
        }
    }

    public static Document createEmptyDocument() throws XSPFException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            return document;
        }
        catch (Exception e) {
            throw new XSPFException("Cannot create document", e);
        }
    }

    public static void saveDocument(Document document, File file) throws XSPFException {
        try {
            XMLFileLoaderStorer.trimBlanks(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new XSPFException("Cannot save file", e);
        }
    }

    private static void trimBlanks(Document document) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String path = "//text()[normalize-space(.)='']";
            NodeList blanks = (NodeList)xpath.evaluate(path, document, XPathConstants.NODESET);
            for (int i = 0; i < blanks.getLength(); ++i) {
                Node blank = blanks.item(i);
                Node parent = blank.getParentNode();
                parent.removeChild(blank);
            }
        }
        catch (XPathExpressionException | DOMException e) {
            throw new DOMException(9, "Could not list text nodes");
        }
    }
}

