/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.base;

import cz.martlin.xspf.playlist.base.XSPFElement;
import cz.martlin.xspf.util.XSPFException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XSPFCollection<E extends XSPFElement>
extends XSPFElement {
    public XSPFCollection(Element container) {
        super(container);
    }

    public E createNew() throws XSPFException {
        Element container = this.getElement();
        String elemName = this.elemName();
        Element elem = UTIL.createNewElement(container, elemName);
        return this.create(elem);
    }

    protected abstract E create(Element var1);

    protected abstract String elemName();

    public void add(E element) throws XSPFException {
        Element container = this.getElement();
        Element elem = ((XSPFElement)element).getElement();
        UTIL.addChildElement(container, elem);
    }

    public void remove(E element) throws XSPFException {
        Element container = this.getElement();
        Element elem = ((XSPFElement)element).getElement();
        UTIL.removeChildElement((Node)container, elem);
    }

    public Iterable<E> iterate() throws XSPFException {
        return this.list().collect(Collectors.toUnmodifiableList());
    }

    public Stream<E> list() throws XSPFException {
        Element container = this.getElement();
        String elemName = this.elemName();
        return UTIL.listChildrenElems(container, elemName).map(e -> this.create((Element)e));
    }

    public int size() throws XSPFException {
        return (int)this.list().count();
    }

    public int hashCode() {
        try {
            return Objects.hash(this.list().toArray());
        }
        catch (XSPFException e) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSPFCollection other = (XSPFCollection)obj;
        try {
            return Objects.deepEquals(this.list().toArray(), other.list().toArray());
        }
        catch (XSPFException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("XSPFCollection[");
        try {
            for (XSPFElement item : this.iterate()) {
                builder.append(item);
                builder.append(", ");
            }
        }
        catch (XSPFException e) {
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }
}

