/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.base;

import cz.martlin.xspf.playlist.base.XSPFElement;
import cz.martlin.xspf.util.XMLDocumentUtility;
import cz.martlin.xspf.util.XSPFException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XSPFNode {
    protected static final XMLDocumentUtility UTIL = new XMLDocumentUtility(null, "http://xspf.org/ns/0/");

    public abstract Node getNode();

    protected <T extends XSPFElement> T createOne(String name, Function<Element, T> mapper) throws XSPFException {
        Node context = this.getNode();
        Element elem = UTIL.createNewElement(context, name);
        return (T)((XSPFElement)mapper.apply(elem));
    }

    protected <T extends XSPFElement> T getOne(String name, Function<Element, T> mapper) throws XSPFException {
        Node owner = this.getNode();
        Element child = UTIL.getChildElemCloneOrNull(owner, name);
        if (child == null) {
            return null;
        }
        return (T)((XSPFElement)mapper.apply(child));
    }

    protected <T extends XSPFElement> T one(String name, Function<Element, T> mapper) throws XSPFException {
        Node owner = this.getNode();
        Element child = UTIL.getOrCreateChildElem(owner, name);
        return (T)((XSPFElement)mapper.apply(child));
    }

    protected <T extends XSPFElement> void setOne(String name, T value) throws XSPFException {
        Node owner = this.getNode();
        Element newElem = value.getElement();
        UTIL.replaceChildElement(owner, name, newElem);
    }

    protected <T extends XSPFElement> List<T> getAll(String name, Function<Element, T> mapper) throws XSPFException {
        Node owner = this.getNode();
        return UTIL.listChildrenElems(owner, name).map(mapper).collect(Collectors.toList());
    }

    protected <T extends XSPFElement> void setAll(String name, List<T> items) throws XSPFException {
        Node owner = this.getNode();
        Stream<Element> elements = items.stream().map(i -> i.getElement());
        UTIL.replaceChildElements(owner, name, elements);
    }
}

