/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.collections;

import cz.martlin.xspf.playlist.base.XSPFCollection;
import cz.martlin.xspf.playlist.elements.XSPFTrack;
import cz.martlin.xspf.util.ExceptionWrapper;
import cz.martlin.xspf.util.XSPFException;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import org.w3c.dom.Element;

public class XSPFTracks
extends XSPFCollection<XSPFTrack> {
    public XSPFTracks(Element trackList) {
        super(trackList);
    }

    @Override
    protected String elemName() {
        return "track";
    }

    @Override
    protected XSPFTrack create(Element track) {
        return new XSPFTrack(track);
    }

    public XSPFTrack createTrack() throws XSPFException {
        return (XSPFTrack)this.createNew();
    }

    public XSPFTrack createTrack(URI location) throws XSPFException {
        XSPFTrack track = (XSPFTrack)this.createNew();
        track.setLocation(location);
        return track;
    }

    public XSPFTrack createTrack(URI location, String title) throws XSPFException {
        XSPFTrack track = (XSPFTrack)this.createNew();
        track.setLocation(location);
        track.setTitle(title);
        return track;
    }

    public XSPFTrack createTrack(URI location, String title, int trackNum, Duration duration) throws XSPFException {
        XSPFTrack track = (XSPFTrack)this.createNew();
        track.setLocation(location);
        track.setTitle(title);
        track.setTrackNum(trackNum);
        track.setDuration(duration);
        return track;
    }

    public XSPFTrack createTrack(URI location, String creator, String album, String title, int trackNum, Duration duration) throws XSPFException {
        XSPFTrack track = (XSPFTrack)this.createNew();
        track.setLocation(location);
        track.setCreator(creator);
        track.setAlbum(album);
        track.setTitle(title);
        track.setTrackNum(trackNum);
        track.setDuration(duration);
        return track;
    }

    public XSPFTrack track(int trackNum) throws XSPFException {
        return this.list().filter(ExceptionWrapper.wrapPredicate(t -> Objects.equals(trackNum, t.getTrackNum()))).findAny().orElse(null);
    }

    public XSPFTrack track(String title) throws XSPFException {
        return this.list().filter(ExceptionWrapper.wrapPredicate(t -> Objects.equals(title, t.getTitle()))).findAny().orElse(null);
    }
}

