/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.elements;

import cz.martlin.xspf.playlist.base.XSPFElement;
import cz.martlin.xspf.util.ExceptionWrapper;
import cz.martlin.xspf.util.XMLDocumentUtilityHelper;
import cz.martlin.xspf.util.XSPFException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class XSPFAttribution
extends XSPFElement {
    public XSPFAttribution(Element attribution) {
        super(attribution);
    }

    public List<XSPFAttributionItem> list() throws XSPFException {
        Element owner = this.getElement();
        return UTIL.listChildrenElems(owner).map(ExceptionWrapper.wrapFunction(e -> this.createItem((Element)e))).collect(Collectors.toList());
    }

    private XSPFAttributionItem createItem(Element elem) throws XSPFException {
        String element = elem.getTagName();
        String value = UTIL.getElementValueOrNull(elem, XMLDocumentUtilityHelper.NullableTextToValueMapper.TEXT_TO_STRING);
        return new XSPFAttributionItem(element, value);
    }

    public void add(XSPFAttributionItem item) throws XSPFException {
        this.add(item.element, item.value);
    }

    public void add(String element, String value) throws XSPFException {
        Element owner = this.getElement();
        Element child = UTIL.getOrCreateChildElem(owner, element);
        UTIL.setElementValue(child, value, XMLDocumentUtilityHelper.NullableValueToTextMapper.STRING_TO_TEXT);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("XSPFAttribution [");
        try {
            builder.append(this.list());
        }
        catch (XSPFException e) {
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        try {
            return Objects.hash(this.list());
        }
        catch (XSPFException e) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSPFAttribution other = (XSPFAttribution)obj;
        try {
            return Objects.equals(this.list(), other.list());
        }
        catch (XSPFException e) {
            return false;
        }
    }

    public static class XSPFAttributionItem {
        public final String element;
        public final String value;

        public XSPFAttributionItem(String element, String value) {
            this.element = element;
            this.value = value;
        }

        public int hashCode() {
            return Objects.hash(this.element, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XSPFAttributionItem other = (XSPFAttributionItem)obj;
            return Objects.equals(this.element, other.element) && Objects.equals(this.value, other.value);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.element);
            builder.append("=");
            builder.append(this.value);
            return builder.toString();
        }
    }
}

