/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.elements;

import cz.martlin.xspf.playlist.base.XSPFCommon;
import cz.martlin.xspf.playlist.collections.XSPFTracks;
import cz.martlin.xspf.playlist.elements.XSPFAttribution;
import cz.martlin.xspf.util.XSPFException;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Objects;
import org.w3c.dom.Element;

public class XSPFPlaylist
extends XSPFCommon {
    public XSPFPlaylist(Element playlist) {
        super(playlist);
    }

    public LocalDateTime getDate() throws XSPFException {
        return this.getDate("date");
    }

    public void setDate(LocalDateTime date) throws XSPFException {
        this.setDate("date", date);
    }

    public URI getLicense() throws XSPFException {
        return this.getUri("license");
    }

    public void setLicense(URI license) throws XSPFException {
        this.setUri("license", license);
    }

    public XSPFAttribution getAttribution() throws XSPFException {
        return this.getOne("attribution", e -> new XSPFAttribution((Element)e));
    }

    public XSPFAttribution attribution() throws XSPFException {
        return this.one("attribution", e -> new XSPFAttribution((Element)e));
    }

    public void setAttribution(XSPFAttribution attribution) throws XSPFException {
        this.setOne("attribution", attribution);
    }

    public XSPFTracks getTracks() throws XSPFException {
        return (XSPFTracks)this.getCollection("trackList", XSPFTracks::new);
    }

    public XSPFTracks tracks() throws XSPFException {
        return (XSPFTracks)this.collection("trackList", XSPFTracks::new);
    }

    public void setTracks(XSPFTracks tracks) throws XSPFException {
        this.setCollection("trackList", tracks);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        try {
            result = 31 * result + Objects.hash(this.attribution(), this.getDate(), this.getLicense(), this.tracks());
        }
        catch (XSPFException xSPFException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSPFPlaylist other = (XSPFPlaylist)obj;
        try {
            return Objects.equals(this.attribution(), other.attribution()) && Objects.equals(this.getDate(), other.getDate()) && Objects.equals(this.getLicense(), other.getLicense()) && Objects.equals(this.tracks(), other.tracks());
        }
        catch (XSPFException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("XSPPlaylist [");
        try {
            builder.append("title=");
            builder.append(this.getTitle());
            builder.append(", tracks=");
            builder.append(this.getTracks());
        }
        catch (XSPFException e) {
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }
}

