/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.util;

import cz.martlin.xspf.playlist.collections.XSPFExtensions;
import cz.martlin.xspf.playlist.collections.XSPFLinks;
import cz.martlin.xspf.playlist.collections.XSPFMetas;
import cz.martlin.xspf.playlist.collections.XSPFTracks;
import cz.martlin.xspf.playlist.elements.XSPFAttribution;
import cz.martlin.xspf.playlist.elements.XSPFExtension;
import cz.martlin.xspf.playlist.elements.XSPFFile;
import cz.martlin.xspf.playlist.elements.XSPFLink;
import cz.martlin.xspf.playlist.elements.XSPFMeta;
import cz.martlin.xspf.playlist.elements.XSPFPlaylist;
import cz.martlin.xspf.playlist.elements.XSPFTrack;
import cz.martlin.xspf.util.XSPFException;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;

public class Printer {
    private static final String PADDING_STEP = "  ";

    public static void print(int padding, String label, XSPFFile file) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        Printer.print(p, "playlist", file.getPlaylist());
    }

    public static void print(int padding, String label, XSPFPlaylist playlist) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        Printer.print(p, "annotation", playlist.getAnnotation());
        Printer.print(p, "creator", playlist.getCreator());
        Printer.print(p, "title", playlist.getTitle());
        Printer.print(p, "attribution", playlist.getAttribution());
        Printer.print(p, "date", playlist.getDate());
        Printer.print(p, "extensions", playlist.getExtensions());
        Printer.print(p, "identifier", playlist.getIdentifier());
        Printer.print(p, "image", playlist.getImage());
        Printer.print(p, "info", playlist.getInfo());
        Printer.print(p, "licence", playlist.getLicense());
        Printer.print(p, "links", playlist.getLinks());
        Printer.print(p, "location", playlist.getLocation());
        Printer.print(p, "metas", playlist.getMetas());
        Printer.print(p, "tracks", playlist.getTracks());
    }

    public static void print(int padding, String label, XSPFTracks tracks) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        for (XSPFTrack track : tracks.iterate()) {
            Printer.print(p, "track", track);
            Printer.printBlankLine();
        }
    }

    public static void print(int padding, String label, XSPFTrack track) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        Printer.print(p, "album", track.getAlbum());
        Printer.print(p, "annotation", track.getAnnotation());
        Printer.print(p, "creator", track.getCreator());
        Printer.print(p, "extensions", track.getExtensions());
        Printer.print(p, "identifier", track.getIdentifier());
        Printer.print(p, "image", track.getImage());
        Printer.print(p, "info", track.getInfo());
        Printer.print(p, "links", track.getLinks());
        Printer.print(p, "location", track.getLocation());
        Printer.print(p, "metas", track.getMetas());
        Printer.print(p, "title", track.getTitle());
        Printer.print(p, "duration", track.getDuration());
        Printer.print(p, "trackNum", track.getTrackNum());
    }

    public static void print(int padding, String label, XSPFMetas metas) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        for (XSPFMeta meta : metas.iterate()) {
            Printer.print(p, "meta", meta);
            Printer.printBlankLine();
        }
    }

    public static void print(int padding, String label, XSPFMeta meta) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        Printer.print(p, "content", meta.getContent());
        Printer.print(p, "rel", meta.getRel());
    }

    public static void print(int padding, String label, XSPFExtensions extensions) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        for (XSPFExtension extension : extensions.iterate()) {
            Printer.print(p, "extension", extension);
            Printer.printBlankLine();
        }
    }

    public static void print(int padding, String label, XSPFExtension extension) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        Printer.print(p, "application", extension.getApplication());
    }

    public static void print(int padding, String label, XSPFLinks links) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        for (XSPFLink link : links.iterate()) {
            Printer.print(p, "link", link);
            Printer.printBlankLine();
        }
    }

    public static void print(int padding, String label, XSPFLink link) throws XSPFException {
        Printer.printLabel(padding, label);
        int p = padding + 1;
        Printer.print(p, "content", link.getContent());
        Printer.print(p, "rel", link.getRel());
    }

    public static void print(int padding, String label, XSPFAttribution attribution) throws XSPFException {
        if (attribution == null) {
            Printer.printLabeled(padding, label, null);
            return;
        }
        Printer.printLabel(padding, label);
        int p = padding + 1;
        for (XSPFAttribution.XSPFAttributionItem item : attribution.list()) {
            Printer.print(p, item.element, item.value);
        }
        Printer.printBlankLine();
    }

    private static void print(int padding, String label, String text) {
        Printer.printLabeled(padding, label, text);
    }

    private static void print(int padding, String label, LocalDateTime date) {
        Printer.printLabeled(padding, label, date);
    }

    private static void print(int padding, String label, URI uri) {
        Printer.printLabeled(padding, label, uri);
    }

    private static void print(int padding, String label, Integer trackNum) {
        Printer.printLabeled(padding, label, trackNum);
    }

    private static void print(int padding, String label, Duration duration) {
        Printer.printLabeled(padding, label, duration);
    }

    private static void printLabel(int padding, String label) {
        String pad = PADDING_STEP.repeat(padding);
        System.out.println(pad + " - " + label + ":");
    }

    private static void printLabeled(int padding, String label, Object value) {
        String pad = PADDING_STEP.repeat(padding);
        String valueStr = String.valueOf(value);
        System.out.println(pad + " - " + label + ": " + valueStr);
    }

    private static void printBlankLine() {
        System.out.println();
    }
}

