/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.util;

import cz.martlin.xspf.util.ExceptionWrapper;
import cz.martlin.xspf.util.XMLDocumentUtilityHelper;
import cz.martlin.xspf.util.XSPFException;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDocumentUtility {
    private final XMLDocumentUtilityHelper helper;

    public XMLDocumentUtility(String nsName, String nsURL) {
        this.helper = new XMLDocumentUtilityHelper(nsName, nsURL);
    }

    public void register(Element elem) throws XSPFException {
        this.helper.specifyNSattribute(elem);
    }

    public <T> T getChildElementValueOrNull(Element owner, String elemName, XMLDocumentUtilityHelper.NullableTextToValueMapper<T> mapper) throws XSPFException {
        Element elem = this.helper.getChildOrNull(owner, elemName);
        if (elem == null) {
            return null;
        }
        return this.getElementValueOrNull(elem, mapper);
    }

    public <T> void setChildElementValue(Element owner, String elemName, T value, XMLDocumentUtilityHelper.NullableValueToTextMapper<T> mapper) throws XSPFException {
        Element elem = this.helper.getOrCreateChild(owner, elemName);
        this.setElementValue(elem, value, mapper);
    }

    public <T> T getElementValueOrNull(Element elem, XMLDocumentUtilityHelper.NullableTextToValueMapper<T> mapper) throws XSPFException {
        String text = this.helper.getElementValueOrNull(elem);
        return this.helper.textToValue(text, mapper);
    }

    public <T> void setElementValue(Element elem, T value, XMLDocumentUtilityHelper.NullableValueToTextMapper<T> mapper) throws XSPFException {
        String text = this.helper.valueToText(value, mapper);
        if (text != null) {
            this.helper.setElementValue(elem, text);
        }
    }

    public <T> T getElementAttrOrNull(Element owner, String attrName, XMLDocumentUtilityHelper.NullableTextToValueMapper<T> mapper) throws XSPFException {
        String text = this.helper.getAttrValueOrNull(owner, attrName);
        return this.helper.textToValue(text, mapper);
    }

    public <T> void setElementAttr(Element owner, String attrName, T value, XMLDocumentUtilityHelper.NullableValueToTextMapper<T> mapper) throws XSPFException {
        String text = this.helper.valueToText(value, mapper);
        if (text != null) {
            this.helper.setAttrValue(owner, attrName, text);
        }
    }

    public Stream<Element> listChildrenElems(Node container) throws XSPFException {
        return this.helper.getChildren(container, null);
    }

    public Stream<Element> listChildrenElems(Node container, String elemName) throws XSPFException {
        return this.helper.getChildren(container, elemName);
    }

    public Stream<Element> listChildrenElemsClones(Node container, String elemName) throws XSPFException {
        return this.helper.getChildren(container, elemName).map(e -> this.helper.clone((Element)e));
    }

    public Element getChildElemOrNull(Node owner, String elemName) throws XSPFException {
        return this.helper.getChildOrNull(owner, elemName);
    }

    public Element getOrCreateChildElem(Node owner, String elemName) throws XSPFException {
        return this.helper.getOrCreateChild(owner, elemName);
    }

    public Element getChildElemCloneOrNull(Node owner, String elemName) throws XSPFException {
        Element elem = this.helper.getChildOrNull(owner, elemName);
        if (elem == null) {
            return null;
        }
        return this.helper.clone(elem);
    }

    public Element getElemClone(Element elem) {
        return this.helper.clone(elem);
    }

    public void removeChildElement(Node owner, String elemName) throws XSPFException {
        Element elem = this.helper.getChildOrNull(owner, elemName);
        if (elem == null) {
            return;
        }
        this.removeChildElement(owner, elem);
    }

    public void removeChildElements(Node owner, String elemName) throws XSPFException {
        Stream<Element> elems = this.helper.getChildren(owner, elemName);
        this.removeChildElements(owner, elems);
    }

    public void replaceChildElement(Node owner, String elemName, Element replacement) throws XSPFException {
        Element elem = this.helper.getChildOrNull(owner, elemName);
        if (elem == null) {
            this.addChildElement(owner, replacement);
        } else {
            this.replaceChildElement(owner, elem, replacement);
        }
    }

    public void replaceChildElements(Node owner, String elemName, Stream<Element> replacements) throws XSPFException {
        Stream<Element> elems = this.helper.getChildren(owner, elemName);
        this.replaceChildElements(owner, elems, replacements);
    }

    public void replaceChildElementByClone(Node owner, String elemName, Element replacement) throws XSPFException {
        Element elem = this.helper.getChildOrNull(owner, elemName);
        Element clone = this.helper.clone(replacement);
        if (elem == null) {
            this.addChildElement(owner, clone);
        } else {
            this.replaceChildElement(owner, elem, clone);
        }
    }

    public void replaceChildElementsByClone(Node owner, String elemName, Stream<Element> replacements) throws XSPFException {
        Stream<Element> elems = this.helper.getChildren(owner, elemName);
        Stream<Element> clones = replacements.map(e -> this.helper.clone((Element)e));
        this.replaceChildElements(owner, elems, clones);
    }

    public Element createNewElement(Node context, String name) throws XSPFException {
        return this.helper.createNew(context, name);
    }

    public void addChildElement(Node owner, Element elem) throws XSPFException {
        this.helper.addChild(owner, elem);
    }

    public void addChildElements(Node owner, Stream<Element> elems) {
        elems.forEach(ExceptionWrapper.wrapConsumer(e -> this.helper.addChild(owner, (Element)e)));
    }

    public void removeChildElement(Node owner, Element elem) throws XSPFException {
        this.helper.removeChild(owner, elem);
    }

    public void removeChildElements(Node owner, Stream<Element> elems) {
        elems.forEach(ExceptionWrapper.wrapConsumer(e -> this.helper.removeChild(owner, (Element)e)));
    }

    public void replaceChildElement(Node owner, Element original, Element replacement) throws XSPFException {
        this.helper.removeChild(owner, original);
        this.helper.addChild(owner, replacement);
    }

    public void replaceChildElements(Node owner, Stream<Element> originals, Stream<Element> replacements) throws XSPFException {
        originals.forEach(ExceptionWrapper.wrapConsumer(e -> this.helper.removeChild(owner, (Element)e)));
        replacements.forEach(ExceptionWrapper.wrapConsumer(e -> this.helper.addChild(owner, (Element)e)));
    }
}

