/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.playlist.elements;

import cz.martlin.xspf.playlist.base.XSPFCommon;
import cz.martlin.xspf.util.XSPFException;
import java.time.Duration;
import java.util.Objects;
import org.w3c.dom.Element;

public class XSPFTrack
extends XSPFCommon {
    public XSPFTrack(Element track) {
        super(track);
    }

    public Duration getDuration() throws XSPFException {
        return this.getDuration("duration");
    }

    public void setDuration(Duration duration) throws XSPFException {
        this.setDuration("duration", duration);
    }

    public String getAlbum() throws XSPFException {
        return this.getStr("album");
    }

    public void setAlbum(String album) throws XSPFException {
        this.setStr("album", album);
    }

    public Integer getTrackNum() throws XSPFException {
        return this.getInt("trackNum");
    }

    public void setTrackNum(int trackNum) throws XSPFException {
        this.setInt("trackNum", trackNum);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        try {
            result = 31 * result + Objects.hash(this.getAlbum(), this.getDuration(), this.getTrackNum());
        }
        catch (XSPFException xSPFException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XSPFTrack other = (XSPFTrack)obj;
        try {
            return Objects.equals(this.getAlbum(), other.getAlbum()) && Objects.equals(this.getDuration(), other.getDuration()) && Objects.equals(this.getTrackNum(), other.getTrackNum());
        }
        catch (XSPFException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("XSPFTrack [");
        try {
            builder.append("title=");
            builder.append(this.getTitle());
            builder.append(", location=");
            builder.append(this.getLocation());
        }
        catch (XSPFException e) {
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }
}

