/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.util;

import cz.martlin.xspf.util.XSPFRuntimeException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ExceptionWrapper {
    public static <T> Consumer<T> wrapConsumer(ConsumerThrowing<T> consumer) {
        return x -> {
            try {
                consumer.consume(x);
            }
            catch (Exception e) {
                throw new XSPFRuntimeException(e);
            }
        };
    }

    public static <IT, OT> Function<IT, OT> wrapFunction(FunctionThrowing<IT, OT> function) {
        return x -> {
            try {
                return function.apply(x);
            }
            catch (Exception e) {
                throw new XSPFRuntimeException(e);
            }
        };
    }

    public static <T> Predicate<T> wrapPredicate(PredicateThrowing<T> predicate) {
        return x -> {
            try {
                return predicate.test(x);
            }
            catch (Exception e) {
                throw new XSPFRuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    public static interface PredicateThrowing<T> {
        public boolean test(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface FunctionThrowing<IT, OT> {
        public OT apply(IT var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ConsumerThrowing<T> {
        public void consume(T var1) throws Exception;
    }
}

