/*
 * Decompiled with CFR 0.152.
 */
package cz.martlin.xspf.util;

import cz.martlin.xspf.util.XSPFException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSPFDocumentUtility {
    private final String nsName;
    private final String nsURL;

    public XSPFDocumentUtility(String nsName, String nsURL) {
        this.nsName = nsName;
        this.nsURL = nsURL;
    }

    public void init(Document document) throws XSPFException {
        this.setNSattribute(document);
    }

    private void setNSattribute(Document document) throws XSPFException {
        Object attrName = this.nsName != null ? "xmlns:" + this.nsName : "xmlns";
        String atrrValue = this.nsURL;
        Element root = this.getRootElem(document);
        root.setAttribute((String)attrName, atrrValue);
    }

    private String fullName(String elemName) {
        if (this.nsName != null) {
            return this.nsName + ":" + elemName;
        }
        return elemName;
    }

    public String getElementText(Element owner, String elemName) throws XSPFException {
        Element child = this.getChild(owner, elemName, true);
        return this.getElementValue(child);
    }

    public void setElementText(Element owner, String elemName, String value) throws XSPFException {
        Element child = this.getOrCreateChild(owner, elemName);
        this.setElementValue(child, value);
    }

    public <T> T getElementValue(Element owner, String elemName, TextToValueMapper<T> mapper) throws XSPFException {
        String text = this.getElementText(owner, elemName);
        return this.textToValue(text, mapper);
    }

    public <T> void setElementValue(Element elem, T value, ValueToTextMapper<T> mapper) throws XSPFException {
        String text = this.valueToText(value, mapper);
        this.setElementValue(elem, text);
    }

    public <T> T getElementValue(Element elem, TextToValueMapper<T> mapper) throws XSPFException {
        String text = this.getElementValue(elem);
        return this.textToValue(text, mapper);
    }

    public <T> void setElementValue(Element owner, String elemName, T value, ValueToTextMapper<T> mapper) throws XSPFException {
        String text = this.valueToText(value, mapper);
        this.setElementText(owner, elemName, text);
    }

    public String getElementAttr(Element owner, String attrName) throws XSPFException {
        return this.getAttrValue(owner, attrName);
    }

    public void setElementAttr(Element owner, String attrName, String value) throws XSPFException {
        this.setAttrValue(owner, attrName, value);
    }

    public <T> T getElementAttr(Element owner, String attrName, TextToValueMapper<T> mapper) throws XSPFException {
        String text = this.getAttrValue(owner, attrName);
        return this.textToValue(text, mapper);
    }

    public <T> void setElementAttr(Element owner, String attrName, T value, ValueToTextMapper<T> mapper) throws XSPFException {
        String text = this.valueToText(value, mapper);
        this.setAttrValue(owner, attrName, text);
    }

    public List<Element> listChildrenElems(Element container, String elemName) {
        return this.listChildren(container, elemName);
    }

    public Element getOrCreateChildElem(Element owner, String elemName) throws XSPFException {
        return this.getOrCreateChild(owner, elemName);
    }

    public Element getOrCreateRootElem(Document doc, String elemName) throws XSPFException {
        return this.getOrCreateChild(doc, elemName);
    }

    public Element getChildElem(Element owner, String elemName) throws XSPFException {
        return this.getChild(owner, elemName, true);
    }

    public Element getRootElem(Document doc, String elemName) throws XSPFException {
        return this.getChild(doc, elemName, true);
    }

    private Element getRootElem(Document document) throws XSPFException {
        Element root = document.getDocumentElement();
        if (root == null) {
            throw new XSPFException("No root element");
        }
        return root;
    }

    public Element replaceChildElem(Element owner, String elemName) throws XSPFException {
        return this.replaceChild(owner, elemName);
    }

    public Element replaceChildElem(Element owner, String elemName, Element replacement) throws XSPFException {
        return this.replaceChild(owner, elemName, replacement);
    }

    public void replaceAllChildren(Element owner, String elemName, List<Element> elements) throws XSPFException {
        this.removeChildren(owner, elemName);
        for (Element elem : elements) {
            owner.appendChild(elem);
        }
    }

    private Element createChild(Node owner, String elemName) {
        Document document = owner.getNodeType() == 9 ? (Document)owner : owner.getOwnerDocument();
        Element child = document.createElement(this.fullName(elemName));
        owner.appendChild(child);
        return child;
    }

    private void removeChildren(Element owner, String elemName) throws XSPFException {
        List<Element> children = this.listChildren(owner, elemName);
        for (Element child : children) {
            owner.removeChild(child);
        }
    }

    private void removeChild(Element owner, String elemName) throws XSPFException {
        Element child = this.getChild(owner, elemName, true);
        owner.removeChild(child);
    }

    private Element getOrCreateChild(Node owner, String elemName) throws XSPFException {
        Element child = this.getChild(owner, elemName, false);
        if (child == null) {
            child = this.createChild(owner, elemName);
        }
        return child;
    }

    private Element replaceChild(Element owner, String elemName) throws XSPFException {
        if (this.hasChild(owner, elemName)) {
            this.removeChild(owner, elemName);
        }
        return this.createChild(owner, elemName);
    }

    private Element replaceChild(Element owner, String elemName, Element replacement) throws XSPFException {
        if (this.hasChild(owner, elemName)) {
            this.removeChild(owner, elemName);
        }
        owner.appendChild(replacement);
        return replacement;
    }

    private boolean hasChild(Node owner, String elemName) {
        List<Element> children = this.listChildren(owner, elemName);
        return !children.isEmpty();
    }

    private Element getChild(Node owner, String elemName, boolean failOnMissing) throws XSPFException {
        List<Element> children = this.listChildren(owner, elemName);
        if (children.size() < 1) {
            if (failOnMissing) {
                throw new XSPFException("No such element " + elemName);
            }
            return null;
        }
        if (children.size() > 1) {
            throw new XSPFException("More than one " + elemName + " elements");
        }
        Node child = children.get(0);
        Element childElem = (Element)child;
        return childElem;
    }

    private List<Element> listChildren(Node container, String elemName) {
        NodeList children = container.getChildNodes();
        return this.listElems(children, elemName);
    }

    private List<Element> listElems(NodeList children, String elemName) {
        return IntStream.range(0, children.getLength()).mapToObj(i -> children.item(i)).filter(n -> n.getNodeType() == 1).map(n -> (Element)n).filter(e -> e.getTagName().equals(this.fullName(elemName))).collect(Collectors.toList());
    }

    private String getElementValue(Element elem) throws XSPFException {
        String content = elem.getTextContent();
        if (content == null) {
            throw new XSPFException("The element " + elem.getTagName() + " has no content");
        }
        return content;
    }

    private void setElementValue(Element elem, String value) {
        elem.setTextContent(value);
    }

    private String getAttrValue(Element elem, String attrName) throws XSPFException {
        String content = elem.getAttribute(this.fullName(attrName));
        if (content == null) {
            throw new XSPFException("The attribute " + attrName + " does not exist");
        }
        return content;
    }

    private void setAttrValue(Element elem, String attrName, String value) {
        elem.setAttribute(this.fullName(attrName), value);
    }

    private <T> T textToValue(String text, TextToValueMapper<T> mapper) throws XSPFException {
        try {
            return mapper.textToValue(text.trim());
        }
        catch (Exception e) {
            throw new XSPFException("Cannot convert " + text + " value", e);
        }
    }

    private <T> String valueToText(T value, ValueToTextMapper<T> mapper) throws XSPFException {
        try {
            return mapper.valueToText(value);
        }
        catch (Exception e) {
            throw new XSPFException("Cannot convert " + value + " value", e);
        }
    }

    @FunctionalInterface
    public static interface ValueToTextMapper<T> {
        public String valueToText(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface TextToValueMapper<T> {
        public T textToValue(String var1) throws Exception;
    }
}

