/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.commons.springfx.service.impl;

import cz.masci.commons.springfx.data.Modifiable;
import cz.masci.commons.springfx.service.ObservableListMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.springframework.stereotype.Service;

@Service
public class ObservableListMapImpl
implements ObservableListMap {
    private final ObservableMap<String, ObservableList<Modifiable>> modifiedMap = FXCollections.observableHashMap();

    @Override
    public <T extends Modifiable> void add(T item) {
        if (item == null) {
            return;
        }
        this.add(item.getClass().getSimpleName(), item);
    }

    @Override
    public <T extends Modifiable> void add(String key, T item) {
        ObservableList<Modifiable> modifiedList = this.getModifiedList(key);
        modifiedList.add(item);
    }

    @Override
    public <T extends Modifiable> void remove(T item) {
        if (item == null) {
            return;
        }
        this.remove(item.getClass().getSimpleName(), item);
    }

    @Override
    public <T extends Modifiable> void remove(String key, T item) {
        ObservableList<Modifiable> modifiedList = this.getModifiedList(key);
        modifiedList.remove(item);
    }

    @Override
    public <T extends Modifiable> boolean contains(T item) {
        if (item == null) {
            return false;
        }
        return this.contains(item.getClass().getSimpleName(), item);
    }

    @Override
    public <T extends Modifiable> boolean contains(String key, T item) {
        return this.getModifiedList(key).contains(item);
    }

    @Override
    public <T extends Modifiable> List<T> getAll(Class<T> key) {
        return this.getAll(key.getSimpleName());
    }

    @Override
    public <T extends Modifiable> List<T> getAll(String key) {
        ObservableList<Modifiable> modifiedList = this.getModifiedList(key);
        return modifiedList.stream().map(item -> item).collect(Collectors.toList());
    }

    @Override
    public <T extends Modifiable> void addListener(Class<T> key, ListChangeListener<T> changeListener) {
        this.addListener(key.getSimpleName(), changeListener);
    }

    @Override
    public void addListener(String key, ListChangeListener<? extends Modifiable> changeListener) {
        ObservableList<Modifiable> modifiedList = this.getModifiedList(key);
        modifiedList.addListener(changeListener);
    }

    @Override
    public <T extends Modifiable> void removeListener(Class<T> key, ListChangeListener<T> changeListener) {
        this.removeListener(key.getSimpleName(), changeListener);
    }

    @Override
    public void removeListener(String key, ListChangeListener<? extends Modifiable> changeListener) {
        ObservableList<Modifiable> modifiedList = this.getModifiedList(key);
        modifiedList.removeListener(changeListener);
    }

    private ObservableList<Modifiable> getModifiedList(String key) {
        return (ObservableList)this.modifiedMap.computeIfAbsent((Object)key, k -> FXCollections.observableArrayList());
    }
}

