/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.interactor.impl;

import com.github.javafaker.Book;
import com.github.javafaker.Faker;
import cz.masci.springfx.demo.interactor.BookInteractor;
import cz.masci.springfx.demo.model.BookDetailModel;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BookInteractorImpl
implements BookInteractor {
    private final Faker faker;

    @Override
    public List<BookDetailModel> list() {
        Book book = this.faker.book();
        BookDetailModel bookDetailModel = new BookDetailModel();
        bookDetailModel.setAuthor(book.author());
        bookDetailModel.setTitle(book.title());
        bookDetailModel.rebaseline();
        return Arrays.asList(bookDetailModel);
    }

    @Override
    public BookDetailModel save(BookDetailModel book) {
        BookDetailModel savedBook = new BookDetailModel();
        savedBook.setId(book.isTransient() ? this.faker.random().nextLong() : ((Long)book.getId()).longValue());
        savedBook.setAuthor(book.getAuthor());
        savedBook.setTitle(book.getTitle());
        savedBook.rebaseline();
        return savedBook;
    }

    @Override
    public void delete(BookDetailModel book) {
        book.setId(null);
    }

    public BookInteractorImpl(Faker faker) {
        this.faker = faker;
    }
}

