/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.controller;

import cz.masci.springfx.demo.interactor.BookInteractor;
import cz.masci.springfx.demo.model.BookDetailModel;
import cz.masci.springfx.demo.model.BookListModel;
import cz.masci.springfx.mvci.controller.ViewProvider;
import cz.masci.springfx.mvci.controller.impl.OperableManagerController;
import cz.masci.springfx.mvci.model.detail.DetailModel;
import cz.masci.springfx.mvci.model.list.Selectable;
import cz.masci.springfx.mvci.util.ConcurrentUtils;
import cz.masci.springfx.mvci.util.builder.BackgroundTaskBuilder;
import cz.masci.springfx.mvci.view.builder.ButtonBuilder;
import cz.masci.springfx.mvci.view.builder.CommandsViewBuilder;
import io.github.palexdev.materialfx.controls.MFXButton;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.layout.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookManagerController
implements ViewProvider<Region> {
    private static final Logger log = LoggerFactory.getLogger(BookManagerController.class);
    private final BookInteractor interactor;
    private final OperableManagerController<Long, BookDetailModel> operableManagerController;
    private final CommandsViewBuilder builder;

    public BookManagerController(BookListModel viewModel, BookInteractor interactor) {
        this.interactor = interactor;
        this.operableManagerController = new OperableManagerController((Selectable)viewModel, viewModel.getElements());
        this.builder = new CommandsViewBuilder(List.of((MFXButton)ButtonBuilder.builder().text("New").command(this::newBook).styleClass("outlined").build(MFXButton::new), (MFXButton)ButtonBuilder.builder().text("Load").command(this::load).styleClass("outlined").build(MFXButton::new), (MFXButton)ButtonBuilder.builder().text("Save All").command(this::save).styleClass("filledTonal").build(MFXButton::new), (MFXButton)ButtonBuilder.builder().text("Discard All").command(this::discard).styleClass("outlined").build(MFXButton::new)));
    }

    public Region getView() {
        return this.builder.build();
    }

    private void newBook() {
        BookDetailModel element = new BookDetailModel();
        element.setTitle("New Book");
        this.operableManagerController.add((DetailModel)element);
    }

    private void load(Runnable postGuiStuff) {
        BackgroundTaskBuilder.task(this.interactor::list).postGuiCall(postGuiStuff).onSucceeded(arg_0 -> this.operableManagerController.addAll(arg_0)).start();
    }

    private void save(Runnable postGuiStuff) {
        AtomicInteger savedCount = new AtomicInteger(0);
        BackgroundTaskBuilder.task(() -> {
            this.operableManagerController.update((element, updateElement) -> {
                try {
                    BookDetailModel savedElement = this.interactor.save((BookDetailModel)((Object)((Object)element)));
                    ConcurrentUtils.runInFXThread(() -> updateElement.accept(savedElement));
                    savedCount.incrementAndGet();
                }
                catch (Exception e) {
                    log.error("Something went wrong when saving", (Throwable)e);
                }
            });
            return null;
        }).onSucceeded(unused -> log.info("{} records were saved", (Object)savedCount.get())).postGuiCall(postGuiStuff).start();
    }

    private void discard() {
        this.operableManagerController.discard();
        log.info("Changes were discarded");
    }
}

