/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.controller;

import cz.masci.springfx.demo.controller.BookDetailController;
import cz.masci.springfx.demo.controller.BookListController;
import cz.masci.springfx.demo.controller.BookManagerController;
import cz.masci.springfx.demo.interactor.BookInteractor;
import cz.masci.springfx.demo.model.BookListModel;
import cz.masci.springfx.mvci.controller.ViewProvider;
import cz.masci.springfx.mvci.util.builder.BackgroundTaskBuilder;
import cz.masci.springfx.mvci.view.builder.BorderPaneBuilder;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;
import org.springframework.stereotype.Component;

@Component
public class BookListDetailController
implements ViewProvider<Region> {
    private final BorderPaneBuilder builder;
    private final BookListModel viewModel;
    private final BookInteractor interactor;

    public BookListDetailController(BookInteractor interactor) {
        this.interactor = interactor;
        this.viewModel = new BookListModel();
        BookListController listController = new BookListController(this.viewModel);
        BookDetailController detailController = new BookDetailController(this.viewModel, interactor);
        BookManagerController managerController = new BookManagerController(this.viewModel, interactor);
        this.builder = BorderPaneBuilder.builder().withTop(managerController.getView()).withLeft(listController.getView()).withCenter(detailController.getView());
    }

    public Region getView() {
        this.load();
        return this.builder.build();
    }

    private void load() {
        this.viewModel.getElements().clear();
        BackgroundTaskBuilder.task(this.interactor::list).onSucceeded(arg_0 -> ((ObservableList)this.viewModel.getElements()).setAll(arg_0)).start();
    }
}

