/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.controller;

import cz.masci.springfx.demo.dialog.LOTRCreateDialog;
import cz.masci.springfx.demo.interactor.LOTRInteractor;
import cz.masci.springfx.demo.model.LOTRDetailModel;
import cz.masci.springfx.demo.model.LOTRListModel;
import cz.masci.springfx.mvci.controller.impl.OperableManagerController;
import cz.masci.springfx.mvci.model.list.Selectable;
import cz.masci.springfx.mvci.util.ConcurrentUtils;
import cz.masci.springfx.mvci.util.builder.BackgroundTaskBuilder;
import cz.masci.springfx.mvci.view.builder.ButtonBuilder;
import cz.masci.springfx.mvci.view.builder.CommandsViewBuilder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.layout.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LOTRManagerController {
    private static final Logger log = LoggerFactory.getLogger(LOTRManagerController.class);
    private final LOTRListModel viewModel;
    private final LOTRInteractor interactor;
    private final OperableManagerController<Long, LOTRDetailModel> operableManagerController;
    private final CommandsViewBuilder viewBuilder;

    public LOTRManagerController(LOTRListModel viewModel, LOTRInteractor interactor) {
        this.viewModel = viewModel;
        this.interactor = interactor;
        this.operableManagerController = new OperableManagerController((Selectable)viewModel, viewModel.getElements());
        this.viewBuilder = new CommandsViewBuilder(List.of(ButtonBuilder.builder().text("Add").command(this::addCharacter).build(Button::new), ButtonBuilder.builder().text("Save all").command(this::saveCharacters).build(Button::new), ButtonBuilder.builder().text("Discard").command(this::discardDirtyItems).build(Button::new), ButtonBuilder.builder().text("Delete").command(this::deleteCharacter).build(Button::new), ButtonBuilder.builder().text("Reload").command(this::loadCharacters).build(Button::new), ButtonBuilder.builder().text("Clear selection").command(this::clearSelection).build(Button::new)));
    }

    public Region getView() {
        this.loadCharacters(() -> {});
        return this.viewBuilder.build();
    }

    private void addCharacter(Runnable postGuiStuff) {
        LOTRCreateDialog dialog = new LOTRCreateDialog();
        dialog.showAndWait().ifPresent(model -> BackgroundTaskBuilder.task(() -> this.interactor.saveCharacter((LOTRDetailModel)((Object)model))).onSucceeded(arg_0 -> this.operableManagerController.add(arg_0)).postGuiCall(postGuiStuff).start());
    }

    private void clearSelection() {
        this.viewModel.clearSelection();
    }

    private void discardDirtyItems() {
        this.operableManagerController.discard();
    }

    private void loadCharacters(Runnable postGuiStuff) {
        BackgroundTaskBuilder.task(this.interactor::loadCharacters).postGuiCall(postGuiStuff).onSucceeded(arg_0 -> this.operableManagerController.addAll(arg_0)).start();
    }

    private void deleteCharacter(Runnable postGuiStuff) {
        Dialog confirmDialog = new Dialog();
        confirmDialog.setTitle("Delete LOTR character confirmation");
        confirmDialog.setContentText("Do you want to delete selected LOTR character?");
        confirmDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        confirmDialog.showAndWait().filter(ButtonType.YES::equals).ifPresent(unused -> this.viewModel.getElements().remove(this.viewModel.getSelectedElement()));
        postGuiStuff.run();
    }

    private void saveCharacters(Runnable postGuiStuff) {
        AtomicInteger savedCount = new AtomicInteger(0);
        BackgroundTaskBuilder.task(() -> {
            this.operableManagerController.update((element, updateElement) -> {
                try {
                    element.rebaseline();
                    ConcurrentUtils.runInFXThread(() -> updateElement.accept(element));
                    savedCount.incrementAndGet();
                }
                catch (Exception e) {
                    log.error("Something went wrong when saving", (Throwable)e);
                }
            });
            return null;
        }).onSucceeded(unused -> log.info("{} records were saved", (Object)savedCount.get())).postGuiCall(postGuiStuff).start();
    }
}

