/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.controller;

import cz.masci.springfx.demo.interactor.PotterInteractor;
import cz.masci.springfx.demo.model.PotterDetailModel;
import cz.masci.springfx.demo.model.PotterListModel;
import cz.masci.springfx.demo.view.PotterDetailViewBuilder;
import cz.masci.springfx.mvci.controller.ViewProvider;
import cz.masci.springfx.mvci.controller.impl.OperableDetailController;
import cz.masci.springfx.mvci.controller.impl.SimpleController;
import cz.masci.springfx.mvci.model.list.Removable;
import cz.masci.springfx.mvci.util.BuilderUtils;
import cz.masci.springfx.mvci.util.ConcurrentUtils;
import cz.masci.springfx.mvci.util.builder.BackgroundTaskBuilder;
import cz.masci.springfx.mvci.view.builder.ButtonBuilder;
import cz.masci.springfx.mvci.view.builder.CommandsViewBuilder;
import io.github.palexdev.materialfx.controls.MFXButton;
import java.util.List;
import javafx.beans.binding.BooleanExpression;
import javafx.geometry.Pos;
import javafx.scene.layout.Region;
import javafx.util.Builder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PotterDetailController
implements ViewProvider<Region> {
    private static final Logger log = LoggerFactory.getLogger(PotterDetailController.class);
    private final OperableDetailController<Long, PotterDetailModel> operableDetailController;
    private final PotterInteractor interactor;
    private final Builder<Region> builder;

    public PotterDetailController(PotterListModel viewModel, PotterInteractor interactor) {
        this.interactor = interactor;
        this.operableDetailController = new OperableDetailController(viewModel.selectedElementProperty(), (Removable)viewModel);
        PotterDetailViewBuilder detailViewBuilder = new PotterDetailViewBuilder(viewModel);
        SimpleController detailController = new SimpleController((Builder)detailViewBuilder);
        CommandsViewBuilder commandViewBuilder = new CommandsViewBuilder(List.of((MFXButton)ButtonBuilder.builder().text("Save").command(this::saveItem).styleClass("filledTonal").disableExpression((BooleanExpression)this.operableDetailController.saveDisabledProperty()).build(MFXButton::new), (MFXButton)ButtonBuilder.builder().text("Cancel").command(this::discardDirtyItem).styleClass("outlined").disableExpression((BooleanExpression)this.operableDetailController.discardDisabledProperty()).build(MFXButton::new), (MFXButton)ButtonBuilder.builder().text("Delete").command(this::deleteItem).disableExpression((BooleanExpression)this.operableDetailController.deleteDisabledProperty()).styleClass("outlined").build(MFXButton::new)), Pos.CENTER_RIGHT);
        this.builder = BuilderUtils.createDetailWithCommandViewBuilder((Region)detailController.getView(), (Region)commandViewBuilder.build());
    }

    public Region getView() {
        return (Region)this.builder.build();
    }

    private void saveItem(Runnable postGuiStuff) {
        this.operableDetailController.update((item, afterSave) -> BackgroundTaskBuilder.task(() -> {
            ConcurrentUtils.runInFXThread(() -> afterSave.accept(item));
            return item;
        }).onFailed(task -> {
            Throwable e = task.getException();
            log.error("Error saving Potter character", e);
        }).onSucceeded(savedItem -> log.info("Potter character was saved")).postGuiCall(postGuiStuff).start());
    }

    private void discardDirtyItem() {
        this.operableDetailController.discard();
    }

    private void deleteItem(Runnable postGuiStuff) {
        this.operableDetailController.remove((item, afterDelete) -> BackgroundTaskBuilder.task(() -> {
            log.info("Deleting item");
            ConcurrentUtils.runInFXThread((Runnable)afterDelete);
            return item;
        }).onFailed(task -> log.error("Something happen when saving Potter character", task.getException())).onSucceeded(deletedItem -> log.info("Potter character was deleted")).postGuiCall(postGuiStuff).start());
    }
}

