/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.controller;

import cz.masci.springfx.demo.interactor.PotterInteractor;
import cz.masci.springfx.demo.model.PotterListModel;
import cz.masci.springfx.demo.view.PotterListViewBuilder;
import cz.masci.springfx.mvci.controller.ViewProvider;
import cz.masci.springfx.mvci.util.builder.BackgroundTaskBuilder;
import javafx.scene.layout.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PotterListController
implements ViewProvider<Region> {
    private static final Logger log = LoggerFactory.getLogger(PotterListController.class);
    private final PotterInteractor interactor;
    private final PotterListModel viewModel;
    private final PotterListViewBuilder viewBuilder;

    public PotterListController(PotterListModel listModel, PotterInteractor interactor) {
        this.viewModel = listModel;
        this.interactor = interactor;
        this.viewBuilder = new PotterListViewBuilder(listModel, this::addCharacter);
    }

    public Region getView() {
        return this.viewBuilder.build();
    }

    private void addCharacter(Runnable postGuiStuff) {
        BackgroundTaskBuilder.task(this.interactor::addCharacter).onFailed(task -> {
            Throwable e = task.getException();
            log.error("Error saving LOTR character", e);
        }).onSucceeded(savedItem -> {
            this.viewModel.getElements().add((Object)savedItem);
            log.info("Potter character was saved");
        }).postGuiCall(postGuiStuff).start();
    }
}

