/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.controller;

import cz.masci.springfx.demo.model.PotterDetailModel;
import cz.masci.springfx.demo.model.PotterListModel;
import cz.masci.springfx.mvci.controller.impl.OperableManagerController;
import cz.masci.springfx.mvci.model.list.Selectable;
import cz.masci.springfx.mvci.util.ConcurrentUtils;
import cz.masci.springfx.mvci.util.builder.BackgroundTaskBuilder;
import cz.masci.springfx.mvci.view.builder.ButtonBuilder;
import cz.masci.springfx.mvci.view.builder.CommandsViewBuilder;
import io.github.palexdev.materialfx.controls.MFXButton;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.layout.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PotterManagerController {
    private static final Logger log = LoggerFactory.getLogger(PotterManagerController.class);
    private final PotterListModel viewModel;
    private final CommandsViewBuilder viewBuilder;
    private final OperableManagerController<Long, PotterDetailModel> operableManagerController;

    public PotterManagerController(PotterListModel viewModel) {
        this.viewModel = viewModel;
        this.operableManagerController = new OperableManagerController((Selectable)viewModel, viewModel.getElements());
        this.viewBuilder = new CommandsViewBuilder(List.of((MFXButton)ButtonBuilder.builder().text("Save all").command(this::saveCharacters).styleClass("filledTonal").build(MFXButton::new), (MFXButton)ButtonBuilder.builder().text("Clear selection").command(this::clearSelection).styleClass("outlined").build(MFXButton::new), (MFXButton)ButtonBuilder.builder().text("Discard").command(this::discardDirtyItems).styleClass("outlined").build(MFXButton::new)));
    }

    public Region getView() {
        return this.viewBuilder.build();
    }

    private void clearSelection() {
        this.viewModel.clearSelection();
    }

    private void discardDirtyItems() {
        this.operableManagerController.discard();
    }

    private void saveCharacters(Runnable postGuiStuff) {
        AtomicInteger savedCount = new AtomicInteger(0);
        BackgroundTaskBuilder.task(() -> {
            this.operableManagerController.update((element, updateElement) -> {
                try {
                    element.rebaseline();
                    ConcurrentUtils.runInFXThread(() -> updateElement.accept(element));
                    savedCount.incrementAndGet();
                }
                catch (Exception e) {
                    log.error("Something went wrong when saving", (Throwable)e);
                }
            });
            return null;
        }).onSucceeded(unused -> log.info("{} records were saved", (Object)savedCount.get())).postGuiCall(postGuiStuff).start();
    }
}

