/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.interactor.impl;

import com.github.javafaker.Faker;
import com.github.javafaker.LordOfTheRings;
import cz.masci.springfx.demo.interactor.LOTRInteractor;
import cz.masci.springfx.demo.model.LOTRDetailModel;
import java.util.List;
import java.util.stream.LongStream;
import org.springframework.stereotype.Service;

@Service
public class LOTRInteractorImpl
implements LOTRInteractor {
    private final Faker faker;

    @Override
    public List<LOTRDetailModel> loadCharacters() {
        return LongStream.range(0L, 10L).mapToObj(this::nextCharacter).peek(unused -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    @Override
    public LOTRDetailModel saveCharacter(LOTRDetailModel model) {
        model.setId(model.isTransient() ? this.faker.random().nextLong() : ((Long)model.getId()).longValue());
        return model;
    }

    private LOTRDetailModel nextCharacter(long id) {
        return this.map(this.faker.lordOfTheRings(), id);
    }

    private LOTRDetailModel map(LordOfTheRings origin, long id) {
        LOTRDetailModel model = new LOTRDetailModel();
        model.setId(id);
        model.setCharacter(origin.character());
        model.setLocation(origin.location());
        model.rebaseline();
        return model;
    }

    public LOTRInteractorImpl(Faker faker) {
        this.faker = faker;
    }
}

