/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.demo.view;

import cz.masci.springfx.demo.model.PotterDetailModel;
import cz.masci.springfx.demo.model.PotterListModel;
import cz.masci.springfx.mvci.model.list.ListModel;
import cz.masci.springfx.mvci.util.BuilderUtils;
import cz.masci.springfx.mvci.util.MFXBuilderUtils;
import cz.masci.springfx.mvci.util.constraint.ConstraintUtils;
import cz.masci.springfx.mvci.util.property.PropertyUtils;
import cz.masci.springfx.mvci.view.builder.DetailViewBuilder;
import io.github.palexdev.materialfx.builders.layout.VBoxBuilder;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.validation.Constraint;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.util.Builder;

public class PotterDetailViewBuilder
extends DetailViewBuilder<PotterDetailModel>
implements Builder<Region> {
    public PotterDetailViewBuilder(PotterListModel viewModel) {
        super((ListModel)viewModel);
    }

    public Region build() {
        Property selectedProperty = this.viewModel.selectedElementProperty();
        MFXTextField bookTextField = MFXBuilderUtils.createTextField((String)"Book", (Double)Double.MAX_VALUE);
        Constraint bookConstraint = ConstraintUtils.isNotEmptyWhenPropertyIsNotEmpty((StringProperty)bookTextField.textProperty(), (Property)selectedProperty, (String)"Book");
        bookConstraint.getCondition().addListener((observableValue, oldValue, newValue) -> System.out.printf("Changed potter book condition: from %s to %s", oldValue, newValue));
        Region bookTextFieldWithValidation = BuilderUtils.enhanceValidatedNodeWithSupportingText((Node)bookTextField, arg_0 -> ((BooleanProperty)PropertyUtils.not((ReadOnlyBooleanProperty)bookTextField.delegateFocusedProperty())).addListener(arg_0), (Constraint[])new Constraint[]{bookConstraint});
        MFXTextField characterTextField = MFXBuilderUtils.createTextField((String)"Character", (Double)Double.MAX_VALUE);
        Constraint characterConstraint = ConstraintUtils.isNotEmptyWhenPropertyIsNotEmpty((StringProperty)characterTextField.textProperty(), (Property)selectedProperty, (String)"Character");
        Region characterTextFieldWithValidation = BuilderUtils.enhanceValidatedNodeWithSupportingText((Node)characterTextField, arg_0 -> ((BooleanBinding)characterTextField.delegateFocusedProperty().not()).addListener(arg_0), (Constraint[])new Constraint[]{characterConstraint});
        MFXTextField locationTextField = MFXBuilderUtils.createTextField((String)"Location", (Double)Double.MAX_VALUE);
        MFXTextField quoteTextField = MFXBuilderUtils.createTextField((String)"Quote", (Double)Double.MAX_VALUE);
        this.bindBidirectional(bookTextField.textProperty(), PotterDetailModel::bookProperty);
        this.bindBidirectional(characterTextField.textProperty(), PotterDetailModel::characterProperty);
        this.bindBidirectional(locationTextField.textProperty(), PotterDetailModel::locationProperty);
        this.bindBidirectional(quoteTextField.textProperty(), PotterDetailModel::quoteProperty);
        this.viewModel.setOnFocusView(() -> ((MFXTextField)bookTextField).requestFocus());
        return (Region)VBoxBuilder.vBox().setSpacing(10.0).setChildren(new Node[]{bookTextFieldWithValidation, characterTextFieldWithValidation, locationTextField, quoteTextField}).setPadding(new Insets(5.0)).getNode();
    }
}

