/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.commons.springfx.autoconfigure;

import cz.masci.commons.springfx.fxml.annotation.FxmlController;
import cz.masci.commons.springfx.fxml.annotation.FxmlRoot;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxLoadException;
import net.rgielen.fxweaver.core.FxWeaver;
import net.rgielen.fxweaver.core.FxmlView;
import net.rgielen.fxweaver.core.SimpleFxControllerAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.stereotype.Component;

@Component
public class ExternalControllerFxWeaver
extends FxWeaver {
    private static final Logger log = LoggerFactory.getLogger(ExternalControllerFxWeaver.class);
    private final Callback<Class<?>, Object> beanFactory = arg_0 -> ((ConfigurableApplicationContext)context).getBean(arg_0);
    private final BuilderFactory builderFactory = type -> {
        if (this.getFxmlViewMergedAnnotation(type).isPresent()) {
            log.debug("Found FxmlView annotation for type {}", (Object)type);
            return () -> this.loadController(type);
        }
        return null;
    };

    public ExternalControllerFxWeaver(ConfigurableApplicationContext context) {
        super(arg_0 -> ((ConfigurableApplicationContext)context).getBean(arg_0), () -> ((ConfigurableApplicationContext)context).close());
    }

    protected <C, V extends Node> FxControllerAndView<C, V> load(Class<C> controllerClass, String location, ResourceBundle resourceBundle) {
        return Optional.ofNullable(this.buildFxmlUrl(controllerClass)).map(url -> this.loadByView(controllerClass, (URL)url, resourceBundle)).orElseGet(() -> SimpleFxControllerAndView.ofController((Object)this.getBean(controllerClass)));
    }

    private <C, V extends Node> FxControllerAndView<C, V> loadByView(Class<C> controllerClass, URL url, ResourceBundle resourceBundle) {
        return this.loadByViewUsingFxmlLoader(new FXMLLoader(), controllerClass, url, resourceBundle);
    }

    <C, V extends Node> FxControllerAndView<C, V> loadByViewUsingFxmlLoader(FXMLLoader loader, Class<C> controllerClass, URL url, ResourceBundle resourceBundle) {
        FxControllerAndView fxControllerAndView;
        block11: {
            log.debug("Loading FXML from {}", (Object)url.getFile());
            InputStream fxmlStream = url.openStream();
            try {
                loader.setLocation(url);
                loader.setControllerFactory(this.beanFactory);
                loader.setBuilderFactory(this.builderFactory);
                if (resourceBundle != null) {
                    loader.setResources(resourceBundle);
                }
                Object controller = null;
                MergedAnnotations controllerAnnotations = MergedAnnotations.from(controllerClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                if (controllerAnnotations.isPresent(FxmlController.class)) {
                    log.debug("FxmlController found");
                    controller = this.getBean(controllerClass);
                    loader.setController(controller);
                }
                if (controllerAnnotations.isPresent(FxmlRoot.class)) {
                    log.debug("FxmlRoot found");
                    loader.setRoot(controller);
                }
                Node view = (Node)loader.load(fxmlStream);
                fxControllerAndView = SimpleFxControllerAndView.of((Object)controller, (Node)view);
                if (fxmlStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fxmlStream != null) {
                        try {
                            fxmlStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FxLoadException("Unable to load FXML file " + url, (Throwable)e);
                }
            }
            fxmlStream.close();
        }
        return fxControllerAndView;
    }

    protected String buildFxmlReference(Class<?> c) {
        return (String)((Object)this.getFxmlViewMergedAnnotation(c).getValue("value", String.class).orElse(c.getSimpleName() + ".fxml"));
    }

    private URL buildFxmlUrl(Class<?> c) {
        log.debug("buildFxmlUrl from {}", c);
        MergedAnnotation<FxmlView> fxmlViewAnnotation = this.getFxmlViewMergedAnnotation(c);
        if (fxmlViewAnnotation.isPresent()) {
            String value = fxmlViewAnnotation.getValue("value", String.class).orElse(null);
            Object object = fxmlViewAnnotation.getSource();
            if (object instanceof Class) {
                Class source = (Class)object;
                return value != null ? source.getResource(value) : null;
            }
        }
        return null;
    }

    private MergedAnnotation<FxmlView> getFxmlViewMergedAnnotation(Class<?> c) {
        MergedAnnotations annotations = MergedAnnotations.from(c, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        return annotations.get(FxmlView.class);
    }
}

