/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.model.dirty;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import org.jetbrains.annotations.NotNull;
import org.nield.dirtyfx.tracking.DirtyProperty;

public class DirtyIntegerProperty
extends IntegerProperty
implements DirtyProperty {
    private final IntegerProperty originalValue;
    private final BooleanProperty isDirty;
    private final IntegerProperty delegate;

    public DirtyIntegerProperty(@NotNull Integer initialValue) {
        this.originalValue = new SimpleIntegerProperty(initialValue.intValue());
        this.delegate = new SimpleIntegerProperty(initialValue.intValue());
        this.isDirty = new SimpleBooleanProperty(false);
        this.addListener((ChangeListener<? super Number>)new WeakChangeListener((observable, oldValue, newValue) -> this.isDirty.set(!Objects.equals(this.getOriginalValue(), newValue))));
    }

    public Integer getOriginalValue() {
        return this.originalValue.get();
    }

    public ObservableIntegerValue originalValueProperty() {
        return this.originalValue;
    }

    public void bind(ObservableValue<? extends Number> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public int get() {
        return this.delegate.get();
    }

    public void set(int value) {
        this.delegate.set(value);
    }

    public Integer getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Number value) {
        this.delegate.setValue(value);
    }

    public void addListener(ChangeListener<? super Number> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super Number> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public boolean isDirty() {
        return this.isDirty.get();
    }

    @NotNull
    public ObservableValue<Boolean> isDirtyProperty() {
        return this.isDirty;
    }

    public void rebaseline() {
        this.originalValue.set(this.get());
        this.isDirty.set(false);
    }

    public void reset() {
        this.set(this.originalValue.get());
        this.isDirty.set(false);
    }
}

