/*
 * Copyright (c) 2023
 *
 * This file is part of commons-springfx library.
 *
 * commons-springfx library is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option)
 *   any later version.
 *
 * commons-springfx library is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
 *    License for more details.
 *
 * You should have received a copy of the GNU General Public License
 *  along with Foobar. If not, see <https://www.gnu.org/licenses/>.
 */

package cz.masci.springfx.mvci.view.impl;

import cz.masci.springfx.mvci.view.DirtyStyleable;
import javafx.scene.control.TableRow;
import org.nield.dirtyfx.tracking.DirtyProperty;

/**
 * JFX table row dirty style implementation.
 *
 * @param <T> Type of row data
 */
public class DirtyJFXTableRow<T extends DirtyProperty> extends TableRow<T> implements DirtyStyleable<T> {

  String dirtyRowStyleClass;

  public DirtyJFXTableRow(String dirtyRowStyleClass) {
    super();
    this.dirtyRowStyleClass = dirtyRowStyleClass;
    initDirtyPropertyChangeListener();
  }

  @Override
  public String getDirtyStyleClass() {
    return dirtyRowStyleClass;
  }

}