/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util;

import java.util.function.Consumer;
import javafx.collections.ListChangeListener;

public final class ListenerUtils {
    public static <T> ListChangeListener<T> createListChangeListener(Consumer<T> onAddItem, Consumer<T> onRemoveItem, Consumer<T> onUpdatedItem, Consumer<T> onPermutatedItem) {
        return c -> {
            while (c.next()) {
                if (c.wasPermutated()) {
                    if (onPermutatedItem == null) continue;
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        onPermutatedItem.accept(c.getList().get(i));
                    }
                    continue;
                }
                if (c.wasUpdated()) {
                    if (onUpdatedItem == null) continue;
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        onUpdatedItem.accept(c.getList().get(i));
                    }
                    continue;
                }
                if (onRemoveItem != null) {
                    for (Object remItem : c.getRemoved()) {
                        onRemoveItem.accept(remItem);
                    }
                }
                if (onAddItem == null) continue;
                for (Object addItem : c.getAddedSubList()) {
                    onAddItem.accept(addItem);
                }
            }
        };
    }

    private ListenerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

