/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.view;

import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.css.Styleable;
import org.nield.dirtyfx.tracking.DirtyProperty;

public interface DirtyStyleable<T extends DirtyProperty>
extends Styleable {
    public String getDirtyStyleClass();

    public ReadOnlyObjectProperty<T> itemProperty();

    default public Optional<T> getItemOptional() {
        return Optional.ofNullable(this.itemProperty()).map(ObservableObjectValue::get);
    }

    default public ChangeListener<? super Boolean> getDirtyPropertyChangeListener() {
        return (dirtyObservable, dirtyOldValue, dirtyNewValue) -> this.updateDirtyClassStyle();
    }

    default public void initDirtyPropertyChangeListener() {
        this.updateDirtyClassStyle();
        ChangeListener<Boolean> dirtyPropertyChangeListener = this.getDirtyPropertyChangeListener();
        this.itemProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.isDirtyProperty().removeListener(dirtyPropertyChangeListener);
            }
            if (newValue != null) {
                newValue.isDirtyProperty().addListener(dirtyPropertyChangeListener);
            }
            this.updateDirtyClassStyle();
        });
    }

    default public void updateDirtyClassStyle() {
        if (Boolean.TRUE.equals(this.getItemOptional().map(DirtyProperty::isDirty).orElse(false))) {
            this.getStyleClass().add((Object)this.getDirtyStyleClass());
        } else {
            this.getStyleClass().remove((Object)this.getDirtyStyleClass());
        }
    }
}

