/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.model.dirty;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import org.jetbrains.annotations.NotNull;
import org.nield.dirtyfx.tracking.DirtyProperty;

public class DirtyBooleanProperty
extends BooleanProperty
implements DirtyProperty {
    private final BooleanProperty originalValue;
    private final BooleanProperty isDirty = new SimpleBooleanProperty(false);
    private final BooleanProperty delegate;
    private final ChangeListener<Boolean> listener = (observable, oldValue, newValue) -> this.isDirty.set(!Objects.equals(this.getOriginalValue(), newValue));

    public DirtyBooleanProperty(@NotNull Boolean initialValue) {
        this.originalValue = new SimpleBooleanProperty(initialValue.booleanValue());
        this.delegate = new SimpleBooleanProperty(initialValue.booleanValue());
        this.addListener((ChangeListener<? super Boolean>)new WeakChangeListener(this.listener));
    }

    public Boolean getOriginalValue() {
        return this.originalValue.get();
    }

    public ObservableValue<Boolean> originalValueProperty() {
        return this.originalValue;
    }

    public void bind(ObservableValue<? extends Boolean> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean get() {
        return this.delegate.get();
    }

    public void set(boolean value) {
        this.delegate.set(value);
    }

    public Boolean getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Boolean value) {
        this.delegate.setValue(value);
    }

    public void addListener(ChangeListener<? super Boolean> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super Boolean> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public boolean isDirty() {
        return this.isDirty.get();
    }

    @NotNull
    public ObservableValue<Boolean> isDirtyProperty() {
        return this.isDirty;
    }

    public void rebaseline() {
        this.originalValue.set(this.get());
        this.isDirty.set(false);
    }

    public void reset() {
        this.set(this.originalValue.get());
        this.isDirty.set(false);
    }
}

