/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.model.dirty;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import org.jetbrains.annotations.NotNull;
import org.nield.dirtyfx.tracking.DirtyProperty;

public class DirtyLongProperty
extends LongProperty
implements DirtyProperty {
    private final LongProperty originalValue;
    private final BooleanProperty isDirty = new SimpleBooleanProperty(false);
    private final LongProperty delegate;
    private final ChangeListener<Number> listener = (observable, oldValue, newValue) -> this.isDirty.set(!Objects.equals(this.getOriginalValue(), newValue));

    public DirtyLongProperty(@NotNull Long initialValue) {
        this.originalValue = new SimpleLongProperty(initialValue.longValue());
        this.delegate = new SimpleLongProperty(initialValue.longValue());
        this.addListener((ChangeListener<? super Number>)new WeakChangeListener(this.listener));
    }

    public Long getOriginalValue() {
        return this.originalValue.get();
    }

    public ObservableValue<Number> originalValueProperty() {
        return this.originalValue;
    }

    public void bind(ObservableValue<? extends Number> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public long get() {
        return this.delegate.get();
    }

    public void set(long value) {
        this.delegate.set(value);
    }

    public Long getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Number value) {
        this.delegate.setValue(value);
    }

    public void addListener(ChangeListener<? super Number> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super Number> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public boolean isDirty() {
        return this.isDirty.get();
    }

    @NotNull
    public ObservableValue<Boolean> isDirtyProperty() {
        return this.isDirty;
    }

    public void rebaseline() {
        this.originalValue.set(this.get());
        this.isDirty.set(false);
    }

    public void reset() {
        this.set(this.originalValue.get());
        this.isDirty.set(false);
    }
}

