/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util;

import java.util.List;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public final class BindingUtils {
    public static <T, U extends Property<T>, V> void bindNullableBidirectional(ObservableValue<V> source, U property, Function<V, U> sourceProperty, T defaultValue) {
        BindingUtils.bindNullableBidirectional(source, List.of(ImmutableTriple.of(property, sourceProperty, defaultValue)));
    }

    public static <T, U extends Property<T>, V> void bindNullableBidirectional(ObservableValue<V> source, List<Triple<U, Function<V, U>, T>> propertyList) {
        if (source.getValue() != null) {
            propertyList.forEach(triplet -> ((Property)triplet.getLeft()).bindBidirectional((Property)((Function)triplet.getMiddle()).apply(source.getValue())));
        } else {
            propertyList.forEach(triplet -> ((Property)triplet.getLeft()).setValue(triplet.getRight()));
        }
        source.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                propertyList.forEach(triplet -> ((Property)triplet.getLeft()).unbindBidirectional((Property)((Function)triplet.getMiddle()).apply(oldValue)));
            }
            if (newValue != null) {
                propertyList.forEach(triplet -> ((Property)triplet.getLeft()).bindBidirectional((Property)((Function)triplet.getMiddle()).apply(newValue)));
            } else {
                propertyList.forEach(triplet -> ((Property)triplet.getLeft()).setValue(triplet.getRight()));
            }
        });
    }

    private BindingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

