/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.model.list;

import cz.masci.springfx.mvci.model.detail.DetailModel;
import cz.masci.springfx.mvci.model.dirty.DirtyListProperty;
import cz.masci.springfx.mvci.model.list.Focusable;
import cz.masci.springfx.mvci.model.list.ListModel;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import org.reactfx.value.Var;

public class SimpleListModel<T, E extends DetailModel<T>>
implements ListModel<E>,
Focusable {
    protected final DirtyListProperty<E> elements = new DirtyListProperty();
    protected final Var<E> selectedElement = Var.newSimpleVar(null);
    protected Consumer<E> onSelectElement;
    protected Runnable onUpdateElementsProperty;
    protected Consumer<E> onRemoveElement;
    protected Runnable onFocusView;

    @Override
    public ObservableList<E> getElements() {
        return this.elements.get();
    }

    @Override
    public Var<E> selectedElementProperty() {
        return this.selectedElement;
    }

    @Override
    public void removeElement(E element) {
        this.selectedElement.setValue(null);
        this.elements.remove(element);
        if (this.onRemoveElement != null) {
            this.onRemoveElement.accept(element);
        }
    }

    @Override
    public void updateElementsProperty() {
        if (this.onUpdateElementsProperty != null) {
            this.onUpdateElementsProperty.run();
        }
    }

    @Override
    public void selectElement(E item) {
        if (this.onSelectElement != null) {
            this.onSelectElement.accept(item);
        }
    }

    @Override
    public void focusView() {
        if (this.onFocusView != null) {
            this.onFocusView.run();
        }
    }

    @Override
    public void setOnSelectElement(Consumer<E> onSelectElement) {
        this.onSelectElement = onSelectElement;
    }

    @Override
    public void setOnUpdateElementsProperty(Runnable onUpdateElementsProperty) {
        this.onUpdateElementsProperty = onUpdateElementsProperty;
    }

    @Override
    public void setOnRemoveElement(Consumer<E> onRemoveElement) {
        this.onRemoveElement = onRemoveElement;
    }

    @Override
    public void setOnFocusView(Runnable onFocusView) {
        this.onFocusView = onFocusView;
    }
}

