/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util;

import java.util.function.Consumer;
import javafx.collections.ListChangeListener;

public class ListChangeListenerBuilder<E> {
    private Consumer<E> onAdd;
    private Consumer<E> onRemove;
    private Consumer<E> onUpdated;
    private Consumer<E> onPermutated;

    public ListChangeListenerBuilder<E> onAdd(Consumer<E> onAdd) {
        this.onAdd = onAdd;
        return this;
    }

    public ListChangeListenerBuilder<E> onRemove(Consumer<E> onRemove) {
        this.onRemove = onRemove;
        return this;
    }

    public ListChangeListenerBuilder<E> onUpdated(Consumer<E> onUpdated) {
        this.onUpdated = onUpdated;
        return this;
    }

    public ListChangeListenerBuilder<E> onPermutated(Consumer<E> onPermutated) {
        this.onPermutated = onPermutated;
        return this;
    }

    public ListChangeListener<E> build() {
        return ListChangeListenerBuilder.createListChangeListener(this.onAdd, this.onRemove, this.onUpdated, this.onPermutated);
    }

    private static <T> ListChangeListener<T> createListChangeListener(Consumer<T> onAddItem, Consumer<T> onRemoveItem, Consumer<T> onUpdatedItem, Consumer<T> onPermutatedItem) {
        return c -> {
            while (c.next()) {
                if (c.wasPermutated()) {
                    if (onPermutatedItem == null) continue;
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        onPermutatedItem.accept(c.getList().get(i));
                    }
                    continue;
                }
                if (c.wasUpdated()) {
                    if (onUpdatedItem == null) continue;
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        onUpdatedItem.accept(c.getList().get(i));
                    }
                    continue;
                }
                if (onRemoveItem != null) {
                    for (Object remItem : c.getRemoved()) {
                        onRemoveItem.accept(remItem);
                    }
                }
                if (onAddItem == null) continue;
                for (Object addItem : c.getAddedSubList()) {
                    onAddItem.accept(addItem);
                }
            }
        };
    }
}

