/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.view.builder;

import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.util.Builder;

public class BorderPaneBuilder
implements Builder<BorderPane> {
    private Region left;
    private Region right;
    private Region center;
    private Region top;
    private Region bottom;
    private Insets padding;

    public static BorderPaneBuilder builder() {
        return new BorderPaneBuilder();
    }

    public BorderPane build() {
        BorderPane result = new BorderPane();
        result.setPadding(this.padding == null ? new Insets(5.0, 5.0, 5.0, 5.0) : this.padding);
        Optional.ofNullable(this.left).ifPresent(arg_0 -> ((BorderPane)result).setLeft(arg_0));
        Optional.ofNullable(this.right).ifPresent(arg_0 -> ((BorderPane)result).setRight(arg_0));
        Optional.ofNullable(this.center).ifPresent(arg_0 -> ((BorderPane)result).setCenter(arg_0));
        Optional.ofNullable(this.top).ifPresent(arg_0 -> ((BorderPane)result).setTop(arg_0));
        Optional.ofNullable(this.bottom).ifPresent(arg_0 -> ((BorderPane)result).setBottom(arg_0));
        return result;
    }

    public BorderPaneBuilder withLeft(Region view) {
        this.left = view;
        return this;
    }

    public BorderPaneBuilder withRight(Region view) {
        this.right = view;
        return this;
    }

    public BorderPaneBuilder withCenter(Region view) {
        this.center = view;
        return this;
    }

    public BorderPaneBuilder withTop(Region view) {
        this.top = view;
        return this;
    }

    public BorderPaneBuilder withBottom(Region view) {
        this.bottom = view;
        return this;
    }

    public BorderPaneBuilder withPadding(Insets padding) {
        this.padding = padding;
        return this;
    }
}

