/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util;

import io.github.palexdev.materialfx.validation.Constraint;
import io.github.palexdev.materialfx.validation.MFXValidator;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Builder;

public final class BuilderUtils {
    public static final PseudoClass INVALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    public static final String ERROR_STYLE_CLASS = "error";

    public static <T extends Node> Region enhanceValidatedNodeWithSupportingText(T validatedNode, Consumer<ChangeListener<? super Boolean>> revalidateFlagListener, Constraint ... inputConstraints) {
        return BuilderUtils.enhanceValidatedNodeWithSupportingText(validatedNode, BuilderUtils.createValidationSupportingText(), revalidateFlagListener, inputConstraints);
    }

    public static <T extends Node> Region enhanceValidatedNodeWithSupportingText(T validatedNode, Label supportingText, Consumer<ChangeListener<? super Boolean>> revalidateFlagListener, Constraint ... inputConstraints) {
        Arrays.stream(inputConstraints).forEach(arg_0 -> ((MFXValidator)((Validated)validatedNode).getValidator()).constraint(arg_0));
        ((Validated)validatedNode).getValidator().validProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                supportingText.setVisible(false);
                supportingText.setManaged(false);
                validatedNode.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, false);
            }
        });
        revalidateFlagListener.accept((ChangeListener<? super Boolean>)((ChangeListener)(observable, oldValue, newValue) -> {
            List constraints;
            if (!oldValue.booleanValue() && newValue.booleanValue() && !(constraints = ((Validated)validatedNode).validate()).isEmpty()) {
                validatedNode.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, true);
                supportingText.setText(((Constraint)constraints.get(0)).getMessage());
                supportingText.setVisible(true);
                supportingText.setManaged(true);
            }
        }));
        VBox result = new VBox(new Node[]{validatedNode, supportingText});
        result.setAlignment(Pos.TOP_LEFT);
        return result;
    }

    public static Label createValidationSupportingText() {
        Label result = new Label();
        result.getStyleClass().add((Object)ERROR_STYLE_CLASS);
        result.setPadding(new Insets(4.0, 16.0, 0.0, 16.0));
        result.setVisible(false);
        result.setManaged(false);
        return result;
    }

    public static Builder<Region> createDetailWithCommandViewBuilder(Region detailView, Region commandView) {
        return () -> {
            VBox.setVgrow((Node)detailView, (Priority)Priority.ALWAYS);
            return new VBox(new Node[]{detailView, commandView});
        };
    }

    private BuilderUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

