/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util.constraint;

import io.github.palexdev.materialfx.validation.Constraint;
import io.github.palexdev.materialfx.validation.Severity;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.apache.commons.lang3.StringUtils;
import org.reactfx.value.Var;

public final class ConstraintUtils {
    public static final int ABILITY_SCORE_MIN = 0;
    public static final int ABILITY_SCORE_MAX = 21;
    private static final String NUMBER_REGEX = "[-+]?\\d+";

    public static Constraint isNotEmpty(StringProperty stringProperty, String fieldName) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(String.format("Pole %s je povinn\u00e9", fieldName)).setCondition((BooleanExpression)stringProperty.isNotEmpty()).get();
    }

    public static Constraint isInAbilityScoresRange(IntegerProperty property, String fieldName) {
        return ConstraintUtils.isInRange(property, fieldName, 0, 21);
    }

    public static Constraint isInRange(IntegerProperty integerProperty, String fieldName, int min, int max) {
        Objects.requireNonNull(integerProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(String.format("Pole %s mus\u00ed b\u00fdt v rozmez\u00ed %d a\u017e %d", fieldName, min, max)).setCondition((BooleanExpression)integerProperty.greaterThanOrEqualTo(min).and((ObservableBooleanValue)integerProperty.lessThanOrEqualTo(max))).get();
    }

    public static Constraint isNumber(StringProperty stringProperty, String fieldName) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(String.format("Pole %s mus\u00ed b\u00fdt \u010d\u00edslo", fieldName)).setCondition((BooleanExpression)Bindings.createBooleanBinding(() -> stringProperty.get() != null && ((String)stringProperty.get()).matches(NUMBER_REGEX), (Observable[])new Observable[]{stringProperty})).get();
    }

    public static Constraint isNumberOrEmpty(StringProperty stringProperty, String fieldName) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(String.format("Pole %s mus\u00ed b\u00fdt \u010d\u00edslo", fieldName)).setCondition((BooleanExpression)Bindings.createBooleanBinding(() -> StringUtils.isBlank((CharSequence)((CharSequence)stringProperty.get())) || ((String)stringProperty.get()).matches(NUMBER_REGEX), (Observable[])new Observable[]{stringProperty})).get();
    }

    public static <T> Constraint isNotEmptyWhenPropertyIsNotEmpty(StringProperty stringProperty, Var<T> nullableProperty, String fieldName) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(String.format("Pole %s je povinn\u00e9", fieldName)).setCondition((BooleanExpression)Bindings.createBooleanBinding(() -> nullableProperty.isEmpty() || StringUtils.isNotBlank((CharSequence)stringProperty.getValue()), (Observable[])new Observable[]{nullableProperty, stringProperty})).get();
    }

    public static <T> Constraint isNumberWhenPropertyIsNotEmpty(StringProperty stringProperty, Var<T> nullableProperty, String fieldName) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(String.format("Pole %s mus\u00ed b\u00fdt \u010d\u00edslo", fieldName)).setCondition((BooleanExpression)Bindings.createBooleanBinding(() -> nullableProperty.isEmpty() || stringProperty.get() != null && ((String)stringProperty.get()).matches(NUMBER_REGEX), (Observable[])new Observable[]{nullableProperty, stringProperty})).get();
    }

    public static <T> Constraint isNumberOrEmptyWhenPropertyIsNotEmpty(StringProperty stringProperty, Var<T> nullableProperty, String fieldName) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(String.format("Pole %s mus\u00ed b\u00fdt \u010d\u00edslo", fieldName)).setCondition((BooleanExpression)Bindings.createBooleanBinding(() -> nullableProperty.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)stringProperty.get())) || ((String)stringProperty.get()).matches(NUMBER_REGEX), (Observable[])new Observable[]{nullableProperty, stringProperty})).get();
    }

    private ConstraintUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

