/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.controller.impl;

import cz.masci.springfx.mvci.model.detail.DetailModel;
import cz.masci.springfx.mvci.model.detail.DirtyModel;
import cz.masci.springfx.mvci.model.detail.IdentifiableModel;
import cz.masci.springfx.mvci.model.detail.ValidModel;
import cz.masci.springfx.mvci.model.list.Removable;
import jakarta.annotation.Nonnull;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class OperableDetailController<I, E extends DetailModel<I>> {
    private final Val<E> selectedElement;
    private final Removable<E> removable;
    private final BooleanProperty saveDisabled = new SimpleBooleanProperty(true);
    private final BooleanProperty discardDisabled = new SimpleBooleanProperty(true);
    private final BooleanProperty deleteDisabled = new SimpleBooleanProperty(true);

    public OperableDetailController(Var<E> selectedElement, @Nonnull Removable<E> removable) {
        this.selectedElement = Val.wrap(selectedElement);
        this.removable = removable;
        this.initDisableProperties();
    }

    public BooleanProperty saveDisabledProperty() {
        return this.saveDisabled;
    }

    public BooleanProperty discardDisabledProperty() {
        return this.discardDisabled;
    }

    public BooleanProperty deleteDisabledProperty() {
        return this.deleteDisabled;
    }

    public void discard() {
        if (this.isDiscardEnabled()) {
            this.selectedElement.ifPresent(element -> {
                if (element.isTransient()) {
                    this.removable.remove((DetailModel)element);
                } else {
                    element.reset();
                }
            });
        }
    }

    public void update(BiConsumer<E, Consumer<E>> updateAction) {
        if (this.isSaveEnabled()) {
            this.selectedElement.ifPresent(element -> updateAction.accept(element, updatedElement -> {
                if (element.isTransient()) {
                    element.setId(updatedElement.getId());
                }
                element.rebaseline();
            }));
        }
    }

    public void remove(BiConsumer<E, Runnable> removeAction) {
        if (this.isDeleteEnabled()) {
            this.selectedElement.ifPresent(element -> removeAction.accept(element, () -> this.removable.remove((DetailModel)element)));
        }
    }

    private void initDisableProperties() {
        Val dirtyProperty = this.selectedElement.flatMap(DirtyModel::isDirtyProperty);
        Val validProperty = this.selectedElement.flatMap(ValidModel::validProperty);
        Val transientProperty = this.selectedElement.flatMap(IdentifiableModel::transientProperty);
        Val saveDisable = Val.combine((ObservableValue)dirtyProperty, (ObservableValue)validProperty, (dirty, valid) -> dirty == false || valid == false);
        this.deleteDisabled.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.selectedElement.isEmpty() || (Boolean)transientProperty.getOrElse((Object)true) != false, (Observable[])new Observable[]{this.selectedElement, transientProperty}));
        this.saveDisabled.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.selectedElement.isEmpty() || (Boolean)saveDisable.getOrElse((Object)true) != false, (Observable[])new Observable[]{this.selectedElement, saveDisable}));
        this.discardDisabled.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.selectedElement.isEmpty() || (Boolean)dirtyProperty.getOrElse((Object)true) == false, (Observable[])new Observable[]{this.selectedElement, dirtyProperty}));
    }

    private boolean isSaveEnabled() {
        return !this.saveDisabled.get();
    }

    private boolean isDiscardEnabled() {
        return !this.discardDisabled.get();
    }

    private boolean isDeleteEnabled() {
        return !this.deleteDisabled.get();
    }
}

