/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util.builder;

import cz.masci.springfx.mvci.model.detail.DetailModel;
import cz.masci.springfx.mvci.model.list.impl.BaseListModel;
import cz.masci.springfx.mvci.util.MFXBuilderUtils;
import cz.masci.springfx.mvci.view.impl.DirtyMFXTableRow;
import io.github.palexdev.materialfx.controls.MFXTableColumn;
import io.github.palexdev.materialfx.controls.MFXTableView;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MFXTableViewBuilder<I, E extends DetailModel<I>> {
    private final BaseListModel<I, E> viewModel;
    private double maxHeight = Double.MAX_VALUE;
    private double maxWidth = Double.MAX_VALUE;
    private final List<ColumnData<I, E>> tableColumnsData = new ArrayList<ColumnData<I, E>>();
    private boolean allowsMultipleSelection = false;

    public static <I, E extends DetailModel<I>> MFXTableViewBuilder<I, E> builder(BaseListModel<I, E> viewModel) {
        return new MFXTableViewBuilder<I, E>(viewModel);
    }

    public MFXTableViewBuilder<I, E> maxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public MFXTableViewBuilder<I, E> maxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public MFXTableViewBuilder<I, E> column(String title, Function<E, String> property) {
        return this.column(title, property, null);
    }

    public MFXTableViewBuilder<I, E> column(String title, Function<E, String> property, Double prefWidth) {
        this.tableColumnsData.add(new ColumnData(title, property, prefWidth));
        return this;
    }

    public MFXTableViewBuilder<I, E> allowsMultipleSelection(boolean allowsMultipleSelection) {
        this.allowsMultipleSelection = allowsMultipleSelection;
        return this;
    }

    public MFXTableView<E> build() {
        List tableColumns = this.tableColumnsData.stream().map(this::createTableColumn).collect(Collectors.toList());
        MFXTableView result = new MFXTableView(this.viewModel.getElements());
        result.setMaxHeight(this.maxHeight);
        result.setMaxWidth(this.maxWidth);
        result.getTableColumns().addAll(tableColumns);
        result.setTableRowFactory(data -> new DirtyMFXTableRow<DetailModel>((MFXTableView<DetailModel>)result, (DetailModel)data, "dirty-row"));
        result.getSelectionModel().setAllowsMultipleSelection(this.allowsMultipleSelection);
        MFXBuilderUtils.initSelectionModel(result.getSelectionModel(), () -> ((MFXTableView)result).update(), this.viewModel);
        return result;
    }

    private MFXTableColumn<E> createTableColumn(ColumnData<I, E> data) {
        MFXTableColumn tableColumn = MFXBuilderUtils.createTableColumn(data.title, data.property);
        if (data.prefWidth != null) {
            tableColumn.setPrefWidth(data.prefWidth.doubleValue());
        }
        return tableColumn;
    }

    private MFXTableViewBuilder(BaseListModel<I, E> viewModel) {
        this.viewModel = viewModel;
    }

    private record ColumnData<I, E extends DetailModel<I>>(String title, Function<E, String> property, Double prefWidth) {
    }
}

