/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util.constraint;

import cz.masci.springfx.mvci.util.constraint.ConditionUtils;
import io.github.palexdev.materialfx.validation.Constraint;
import io.github.palexdev.materialfx.validation.Severity;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.binding.NumberExpression;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;

public final class ConstraintUtils {
    public static Constraint isNotEmpty(StringProperty stringProperty, String message) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isNotEmpty((ObservableStringValue)stringProperty)).get();
    }

    public static Constraint isInRange(IntegerProperty integerProperty, String message, int min, int max) {
        Objects.requireNonNull(integerProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isInRange((NumberExpression)integerProperty, min, max)).get();
    }

    public static Constraint isNumber(StringProperty stringProperty, String message) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isNumber((ObservableStringValue)stringProperty)).get();
    }

    public static Constraint isNumberOrEmpty(StringProperty stringProperty, String message) {
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isNumberOrEmpty((ObservableStringValue)stringProperty)).get();
    }

    public static <T> Constraint isNotEmptyWhenPropertyIsNotEmpty(StringProperty stringProperty, Property<T> nullableProperty, String message) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isNotBlankWhenPropertyIsNotEmpty((ObservableStringValue)stringProperty, nullableProperty)).get();
    }

    public static <T> Constraint isNumberWhenPropertyIsNotEmpty(StringProperty stringProperty, Property<T> nullableProperty, String message) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isNumberWhenPropertyIsNotEmpty((ObservableStringValue)stringProperty, nullableProperty)).get();
    }

    public static <T> Constraint isNumberOrEmptyWhenPropertyIsNotEmpty(StringProperty stringProperty, Property<T> nullableProperty, String message) {
        Objects.requireNonNull(nullableProperty);
        Objects.requireNonNull(stringProperty);
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isNumberOrBlankWhenPropertyIsNotEmpty((ObservableStringValue)stringProperty, nullableProperty)).get();
    }

    public static <T, U extends Validated> Constraint isValid(String message, ObservableValue<T> parent, Function<T, ObservableValue<U>> childMap) {
        return Constraint.Builder.build().setSeverity(Severity.ERROR).setMessage(message).setCondition(ConditionUtils.isValid(parent, childMap)).get();
    }

    private ConstraintUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

