/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.view.builder;

import jakarta.annotation.Nonnull;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Builder;

public class CommandsViewBuilder
implements Builder<Region> {
    private final List<? extends Button> buttons;
    private final Pos alignment;
    private final boolean isVertical;

    public CommandsViewBuilder(@Nonnull List<? extends Button> buttons) {
        this(buttons, false, Pos.CENTER_LEFT);
    }

    public CommandsViewBuilder(@Nonnull List<? extends Button> buttons, @Nonnull Pos alignment) {
        this(buttons, false, alignment);
    }

    public CommandsViewBuilder(@Nonnull List<? extends Button> buttons, boolean isVertical, @Nonnull Pos alignment) {
        this.buttons = buttons;
        this.isVertical = isVertical;
        this.alignment = alignment;
    }

    public Region build() {
        Node[] children = (Node[])this.buttons.toArray(new Button[0]);
        double spacing = 15.0;
        VBox result = this.isVertical ? this.createVBox(spacing, this.alignment, children) : this.createHBox(spacing, this.alignment, children);
        result.setPadding(new Insets(10.0));
        return result;
    }

    private HBox createHBox(double spacing, Pos alignment, Node ... children) {
        HBox hBox = new HBox(children);
        hBox.setSpacing(spacing);
        hBox.setAlignment(alignment);
        return hBox;
    }

    private VBox createVBox(double spacing, Pos alignment, Node ... children) {
        VBox vBox = new VBox(children);
        vBox.setSpacing(spacing);
        vBox.setAlignment(alignment);
        return vBox;
    }
}

