/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.controller.impl;

import cz.masci.springfx.mvci.model.detail.DetailModel;
import cz.masci.springfx.mvci.model.detail.DirtyModel;
import cz.masci.springfx.mvci.model.list.Focusable;
import cz.masci.springfx.mvci.model.list.Removable;
import cz.masci.springfx.mvci.model.list.Selectable;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.collections.ObservableList;

public class OperableManagerController<I, E extends DetailModel<I>> {
    private final Selectable<E> selectable;
    private final Focusable focusable;
    private final Removable<E> removable;
    private final ObservableList<E> elements;

    public <T extends Selectable<E> & Focusable> OperableManagerController(T model, ObservableList<E> elements) {
        this.elements = elements;
        this.selectable = model;
        this.focusable = model;
        this.removable = (Removable)model;
    }

    public void add(E element) {
        this.elements.add(element);
        this.selectable.select(element);
        this.focusable.focus();
    }

    public void addAll(List<E> newElements) {
        this.selectable.select(null);
        this.elements.clear();
        this.elements.addAll(newElements);
    }

    public void update(BiConsumer<E, Consumer<E>> updateAction) {
        this.getDirtyElements().filter(Validated::isValid).forEach(element -> updateAction.accept(element, updatedElement -> {
            if (element.isTransient()) {
                element.setId(updatedElement.getId());
            }
            element.rebaseline();
        }));
    }

    public void discard() {
        ArrayList<DetailModel> elementsToRemove = new ArrayList<DetailModel>();
        this.getDirtyElements().forEach(element -> {
            if (element.isTransient()) {
                elementsToRemove.add((DetailModel)element);
            } else {
                element.reset();
            }
        });
        elementsToRemove.forEach(this.removable::remove);
    }

    protected Stream<E> getDirtyElements() {
        return this.elements.stream().filter(DirtyModel::isDirty);
    }

    public OperableManagerController(Selectable<E> selectable, Focusable focusable, Removable<E> removable, ObservableList<E> elements) {
        this.selectable = selectable;
        this.focusable = focusable;
        this.removable = removable;
        this.elements = elements;
    }
}

