/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util;

import cz.masci.springfx.mvci.model.detail.DetailModel;
import cz.masci.springfx.mvci.model.list.impl.BaseListModel;
import io.github.palexdev.materialfx.builders.control.TextFieldBuilder;
import io.github.palexdev.materialfx.controls.MFXTableColumn;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.controls.cell.MFXTableRowCell;
import io.github.palexdev.materialfx.enums.FloatMode;
import io.github.palexdev.materialfx.selection.base.IMultipleSelectionModel;
import java.util.Comparator;
import java.util.function.Function;
import javafx.beans.property.MapProperty;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import org.reactfx.EventStreams;

public final class MFXBuilderUtils {
    public static MFXTextField createTextField(String floatingText, Double maxWidth) {
        return (MFXTextField)TextFieldBuilder.textField().setFloatMode(FloatMode.BORDER).setFloatingText(floatingText).setMaxWidth(maxWidth.doubleValue()).getNode();
    }

    public static <T> MFXTableColumn<T> createTableColumn(String title, Function<T, String> extractor) {
        MFXTableColumn result = new MFXTableColumn(title, Comparator.comparing(extractor));
        result.setRowCellFactory(item -> new MFXTableRowCell(extractor));
        return result;
    }

    public static <T, E extends DetailModel<T>> void initSelectionModel(IMultipleSelectionModel<E> selectionModel, Runnable update, BaseListModel<T, E> viewModel) {
        MapProperty selectionProperty = selectionModel.selectionProperty();
        EventStreams.changesOf((ObservableMap)selectionProperty).filter(MapChangeListener.Change::wasAdded).map(MapChangeListener.Change::getValueAdded).feedTo(viewModel.selectedElementProperty());
        viewModel.setOnUpdateElementsProperty(update);
        viewModel.setOnSelectElement(arg_0 -> selectionModel.selectItem(arg_0));
    }

    private MFXBuilderUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

