/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.util.constraint;

import io.github.palexdev.materialfx.validation.Validated;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.NumberExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.StringUtils;
import org.reactfx.value.Val;

public final class ConditionUtils {
    private static final String NUMBER_REGEX = "[-+]?\\d+";

    public static BooleanExpression isEmpty(ObservableStringValue value) {
        return Bindings.isEmpty((ObservableStringValue)value);
    }

    public static <T> BooleanExpression isEmpty(Val<T> value) {
        return Bindings.createBooleanBinding(() -> value.isEmpty(), (Observable[])new Observable[]{value});
    }

    public static BooleanExpression isNotEmpty(ObservableStringValue value) {
        return Bindings.isNotEmpty((ObservableStringValue)value);
    }

    public static <T> BooleanExpression isNotEmpty(Val<T> value) {
        return Bindings.createBooleanBinding(() -> !value.isEmpty(), (Observable[])new Observable[]{value});
    }

    public static BooleanExpression isBlank(ObservableStringValue value) {
        return Bindings.createBooleanBinding(() -> StringUtils.isBlank((CharSequence)((CharSequence)value.getValue())), (Observable[])new Observable[]{value});
    }

    public static BooleanExpression isNotBlank(ObservableStringValue value) {
        return Bindings.createBooleanBinding(() -> StringUtils.isNotBlank((CharSequence)((CharSequence)value.getValue())), (Observable[])new Observable[]{value});
    }

    public static BooleanExpression isInRange(NumberExpression value, int min, int max) {
        return Bindings.and((ObservableBooleanValue)value.greaterThanOrEqualTo(min), (ObservableBooleanValue)value.lessThanOrEqualTo(max));
    }

    public static BooleanExpression isNumber(ObservableStringValue value) {
        return Bindings.createBooleanBinding(() -> value.getValue() != null && ((String)value.getValue()).matches(NUMBER_REGEX), (Observable[])new Observable[]{value});
    }

    public static BooleanExpression isNumberOrEmpty(ObservableStringValue value) {
        return Bindings.or((ObservableBooleanValue)Bindings.isEmpty((ObservableStringValue)value), (ObservableBooleanValue)ConditionUtils.isNumber(value));
    }

    public static BooleanExpression isNumberOrBlank(ObservableStringValue value) {
        return Bindings.or((ObservableBooleanValue)ConditionUtils.isBlank(value), (ObservableBooleanValue)ConditionUtils.isNumber(value));
    }

    public static <T> BooleanExpression isNotBlankWhenPropertyIsNotEmpty(ObservableStringValue value, ObservableValue<T> property) {
        Val val = Val.wrap(property);
        return Bindings.and((ObservableBooleanValue)ConditionUtils.isNotEmpty(val), (ObservableBooleanValue)ConditionUtils.isNotBlank(value));
    }

    public static <T> BooleanExpression isNumberWhenPropertyIsNotEmpty(ObservableStringValue value, ObservableValue<T> property) {
        Val val = Val.wrap(property);
        return Bindings.and((ObservableBooleanValue)ConditionUtils.isNotEmpty(val), (ObservableBooleanValue)ConditionUtils.isNumber(value));
    }

    public static <T> BooleanExpression isNumberOrBlankWhenPropertyIsNotEmpty(ObservableStringValue value, ObservableValue<T> property) {
        Val val = Val.wrap(property);
        return Bindings.and((ObservableBooleanValue)ConditionUtils.isNotEmpty(val), (ObservableBooleanValue)ConditionUtils.isNumberOrBlank(value));
    }

    public static <T, U extends Validated> BooleanExpression isValid(ObservableValue<T> parent, Function<T, ? extends ObservableValue<U>> value) {
        Val valid = Val.flatMap(parent, value).flatMap(child -> child.getValidator().validProperty());
        return Bindings.createBooleanBinding(() -> (Boolean)valid.getOrElse((Object)false), (Observable[])new Observable[]{valid});
    }

    private ConditionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

