/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.model.dirty;

import cz.masci.springfx.mvci.util.builder.ListChangeListenerBuilder;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import org.jetbrains.annotations.NotNull;
import org.nield.dirtyfx.tracking.DirtyProperty;

public class DirtyListProperty<E extends DirtyProperty>
extends ListProperty<E>
implements DirtyProperty {
    private final BooleanProperty isDirty = new SimpleBooleanProperty(false);
    private final ListProperty<E> delegate = new SimpleListProperty(FXCollections.observableArrayList());
    private final ChangeListener<Boolean> dirtyChangeListener = (observable, oldValue, newValue) -> {
        if (!newValue.booleanValue() && this.isDirty.get()) {
            this.revalidateIsDirty();
        }
        if (newValue.booleanValue()) {
            this.isDirty.set(true);
        }
    };

    public DirtyListProperty() {
        ListChangeListenerBuilder<DirtyProperty> listChangeListenerBuilder = new ListChangeListenerBuilder<DirtyProperty>();
        listChangeListenerBuilder.onAdd(this::onAdd).onUpdated(this::updateDirty).onRemove(this::onRemove);
        this.addListener((ListChangeListener<? super E>)new WeakListChangeListener(listChangeListenerBuilder.build()));
    }

    private void onAdd(E element) {
        this.updateDirty(element);
        element.isDirtyProperty().addListener(this.dirtyChangeListener);
    }

    private void onRemove(E element) {
        element.isDirtyProperty().removeListener(this.dirtyChangeListener);
        if (element.isDirty()) {
            this.revalidateIsDirty();
        }
    }

    private void updateDirty(E element) {
        if (!this.isDirty()) {
            this.isDirty.set(element.isDirty());
        }
    }

    private void revalidateIsDirty() {
        boolean stillDirty = this.get().stream().anyMatch(DirtyProperty::isDirty);
        if (!stillDirty) {
            this.isDirty.set(false);
        }
    }

    public ReadOnlyIntegerProperty sizeProperty() {
        return this.delegate.sizeProperty();
    }

    public ReadOnlyBooleanProperty emptyProperty() {
        return this.delegate.emptyProperty();
    }

    public void bind(ObservableValue<? extends ObservableList<E>> observable) {
        this.delegate.bind(observable);
    }

    public void unbind() {
        this.delegate.unbind();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ObservableList<E> get() {
        return (ObservableList)this.delegate.get();
    }

    public void set(ObservableList<E> value) {
        this.delegate.set(value);
    }

    public void addListener(ChangeListener<? super ObservableList<E>> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(ListChangeListener<? super E> listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ListChangeListener<? super E> listener) {
        this.delegate.removeListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.delegate.removeListener(listener);
    }

    public boolean isDirty() {
        return this.isDirty.get();
    }

    @NotNull
    public ObservableValue<Boolean> isDirtyProperty() {
        return this.isDirty;
    }

    public void rebaseline() {
        this.get().stream().filter(DirtyProperty::isDirty).forEach(DirtyProperty::rebaseline);
        this.isDirty.set(false);
    }

    public void reset() {
        this.get().stream().filter(DirtyProperty::isDirty).forEach(DirtyProperty::reset);
        this.isDirty.set(false);
    }
}

