/*
 * Decompiled with CFR 0.152.
 */
package cz.masci.springfx.mvci.model.list.impl;

import cz.masci.springfx.mvci.model.detail.DetailModel;
import cz.masci.springfx.mvci.model.list.Elements;
import cz.masci.springfx.mvci.model.list.ListModel;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Callback;

public class BaseListModel<I, E extends DetailModel<I>>
implements ListModel<E>,
Elements<E> {
    protected final ObservableList<E> elements;
    protected final ObjectProperty<E> selectedElement = new SimpleObjectProperty();
    protected Consumer<E> onSelectElement;
    protected Runnable onUpdateElementsProperty;
    protected Consumer<E> onRemoveElement;
    protected Runnable onFocusView;

    public BaseListModel() {
        this.elements = FXCollections.observableArrayList();
    }

    public BaseListModel(Callback<E, Observable[]> extractor) {
        this.elements = FXCollections.observableArrayList(extractor);
    }

    @Override
    public ObservableList<E> getElements() {
        return this.elements;
    }

    @Override
    public Property<E> selectedElementProperty() {
        return this.selectedElement;
    }

    @Override
    public void remove(E element) {
        this.selectedElement.setValue(null);
        if (this.elements.remove(element) && this.onRemoveElement != null) {
            this.onRemoveElement.accept(element);
        }
    }

    @Override
    public void update() {
        if (this.onUpdateElementsProperty != null) {
            this.onUpdateElementsProperty.run();
        }
    }

    @Override
    public void select(E item) {
        if (this.onSelectElement != null) {
            this.onSelectElement.accept(item);
        }
    }

    @Override
    public void focus() {
        if (this.onFocusView != null) {
            this.onFocusView.run();
        }
    }

    @Override
    public void setOnSelectElement(Consumer<E> onSelectElement) {
        this.onSelectElement = onSelectElement;
    }

    @Override
    public void setOnUpdateElementsProperty(Runnable onUpdateElementsProperty) {
        this.onUpdateElementsProperty = onUpdateElementsProperty;
    }

    @Override
    public void setOnRemoveElement(Consumer<E> onRemoveElement) {
        this.onRemoveElement = onRemoveElement;
    }

    @Override
    public void setOnFocusView(Runnable onFocusView) {
        this.onFocusView = onFocusView;
    }
}

